/*
 * Decompiled with CFR 0.152.
 */
package ar.com.kfgodel.nary.impl;

import ar.com.kfgodel.nary.api.Nary;
import ar.com.kfgodel.nary.api.Unary;
import ar.com.kfgodel.nary.api.exceptions.MoreThanOneElementException;
import ar.com.kfgodel.nary.impl.NarySupport;
import ar.com.kfgodel.nary.impl.OneElementNary;
import com.google.common.base.MoreObjects;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class StreamBasedNary<T>
extends NarySupport<T> {
    private Stream<? extends T> sourceStream;
    private Unary<T> cachedUnary;

    public static <T> StreamBasedNary<T> create(Stream<? extends T> source) {
        StreamBasedNary<T> nary = new StreamBasedNary<T>();
        nary.sourceStream = source;
        return nary;
    }

    @Override
    public Unary<T> unique() throws MoreThanOneElementException {
        if (this.cachedUnary == null) {
            this.cachedUnary = this.reduceStreamToUnary();
        }
        return this.cachedUnary;
    }

    @Override
    public List<T> collectToList() {
        return this.collect(Collectors.toList());
    }

    @Override
    public Set<T> collectToSet() {
        return this.collect(Collectors.toSet());
    }

    private Unary<T> reduceStreamToUnary() {
        Iterator iterator = this.asStream().iterator();
        if (!iterator.hasNext()) {
            return Nary.empty();
        }
        Object onlyElement = iterator.next();
        if (iterator.hasNext()) {
            throw new MoreThanOneElementException("Expecting only 1 element in the stream to treat it as an optional but found at least 2: " + Arrays.asList(onlyElement, iterator.next()));
        }
        return OneElementNary.create(onlyElement);
    }

    @Override
    protected Stream<T> asStream() {
        if (this.cachedUnary != null) {
            return this.cachedUnary;
        }
        return this.sourceStream;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("cachedOptional", this.cachedUnary).add("sourceStream", this.sourceStream).toString();
    }
}

