/*
 * Decompiled with CFR 0.152.
 */
package info.leadinglight.jdot;

import info.leadinglight.jdot.Edge;
import info.leadinglight.jdot.Node;
import info.leadinglight.jdot.SubGraph;
import info.leadinglight.jdot.enums.Color;
import info.leadinglight.jdot.enums.Position;
import info.leadinglight.jdot.enums.Style;
import info.leadinglight.jdot.impl.AbstractElement;
import info.leadinglight.jdot.impl.AbstractGraph;
import info.leadinglight.jdot.impl.Attrs;

public class ClusterGraph
extends AbstractGraph {
    public ClusterGraph() {
    }

    public ClusterGraph(String name) {
        super(name);
    }

    @Override
    public ClusterGraph addNode(Node n) {
        super.addNode(n);
        return this;
    }

    @Override
    public ClusterGraph addNodes(Node ... nodes) {
        super.addNodes(nodes);
        return this;
    }

    @Override
    public ClusterGraph addEdge(Edge e) {
        super.addEdge(e);
        return this;
    }

    @Override
    public ClusterGraph addEdge(String name, String ... names) {
        super.addEdge(name, names);
        return this;
    }

    @Override
    public ClusterGraph addEdges(Edge ... edges) {
        super.addEdges(edges);
        return this;
    }

    public ClusterGraph addSubGraph(SubGraph subGraph) {
        super.addGraph(subGraph);
        return this;
    }

    public ClusterGraph addClusterGraph(ClusterGraph clusterGraph) {
        super.addGraph(clusterGraph);
        return this;
    }

    @Override
    public String toDot() {
        String dot = "subgraph";
        if (this.getName() != null && this.getName().length() > 0) {
            dot = !this.getName().startsWith("cluster") ? dot + " cluster" + this.getName() : dot + " " + this.getName();
        }
        dot = dot + " { ";
        if (this.getAttrs().has()) {
            dot = dot + "graph [" + this.getAttrs().getAsString() + "] ";
        }
        for (AbstractElement e : this.getElements()) {
            dot = dot + e.toDot();
        }
        dot = dot + "} ";
        return dot;
    }

    public ClusterGraph setK(double k) {
        this.getAttrs().set(Attrs.Key.K, k);
        return this;
    }

    public ClusterGraph setURL(String url) {
        this.getAttrs().set(Attrs.Key.URL, url);
        return this;
    }

    public ClusterGraph setArea(double area) {
        this.getAttrs().set(Attrs.Key.area, area);
        return this;
    }

    public ClusterGraph setBgColor(String color) {
        this.getAttrs().set(Attrs.Key.bgcolor, color);
        return this;
    }

    public ClusterGraph setBgColor(Color.X11 color) {
        this.getAttrs().set(Attrs.Key.bgcolor, (Object)color);
        return this;
    }

    public ClusterGraph setBgColor(Color.SVG color) {
        this.getAttrs().set(Attrs.Key.bgcolor, (Object)color);
        return this;
    }

    public ClusterGraph setColor(String color) {
        this.getAttrs().set(Attrs.Key.color, color);
        return this;
    }

    public ClusterGraph setColor(Color.X11 color) {
        this.getAttrs().set(Attrs.Key.color, (Object)color);
        return this;
    }

    public ClusterGraph setColor(Color.SVG color) {
        this.getAttrs().set(Attrs.Key.color, (Object)color);
        return this;
    }

    public ClusterGraph setColorScheme(String scheme) {
        this.getAttrs().set(Attrs.Key.colorscheme, scheme);
        return this;
    }

    public ClusterGraph setFillColor(String color) {
        this.getAttrs().set(Attrs.Key.fillcolor, color);
        return this;
    }

    public ClusterGraph setFillColor(Color.X11 color) {
        this.getAttrs().set(Attrs.Key.fillcolor, (Object)color);
        return this;
    }

    public ClusterGraph setFillColor(Color.SVG color) {
        this.getAttrs().set(Attrs.Key.fillcolor, (Object)color);
        return this;
    }

    public ClusterGraph setFontColor(String fontcolor) {
        this.getAttrs().set(Attrs.Key.fontcolor, fontcolor);
        return this;
    }

    public ClusterGraph setFontColor(Color.X11 fontcolor) {
        this.getAttrs().set(Attrs.Key.fontcolor, (Object)fontcolor);
        return this;
    }

    public ClusterGraph setFontColor(Color.SVG fontcolor) {
        this.getAttrs().set(Attrs.Key.fontcolor, (Object)fontcolor);
        return this;
    }

    public ClusterGraph setFontName(String fontname) {
        this.getAttrs().set(Attrs.Key.fontname, fontname);
        return this;
    }

    public ClusterGraph setFontSize(double fontsize) {
        this.getAttrs().set(Attrs.Key.fontsize, fontsize);
        return this;
    }

    public ClusterGraph setGradientAngle(int val) {
        this.getAttrs().set(Attrs.Key.gradientangle, val);
        return this;
    }

    public ClusterGraph setHref(String val) {
        this.getAttrs().set(Attrs.Key.href, val);
        return this;
    }

    public ClusterGraph setId(String val) {
        this.getAttrs().set(Attrs.Key.id, val);
        return this;
    }

    public ClusterGraph setLabel(String label) {
        this.getAttrs().set(Attrs.Key.label, label);
        return this;
    }

    public ClusterGraph setLabelJust(Position.X val) {
        this.getAttrs().set(Attrs.Key.labeljust, (Object)val);
        return this;
    }

    public ClusterGraph setLabelLoc(Position.Y val) {
        this.getAttrs().set(Attrs.Key.labelloc, (Object)val);
        return this;
    }

    public ClusterGraph setLayer(String val) {
        this.getAttrs().set(Attrs.Key.layer, val);
        return this;
    }

    public ClusterGraph setLHeight(double val) {
        this.getAttrs().set(Attrs.Key.lheight, val);
        return this;
    }

    public ClusterGraph setLp(String val) {
        this.getAttrs().set(Attrs.Key.lp, val);
        return this;
    }

    public ClusterGraph setLWidth(double val) {
        this.getAttrs().set(Attrs.Key.lwidth, val);
        return this;
    }

    public ClusterGraph setMargin(double val) {
        this.getAttrs().set(Attrs.Key.margin, val);
        return this;
    }

    public ClusterGraph setMargin(String val) {
        this.getAttrs().set(Attrs.Key.margin, val);
        return this;
    }

    public ClusterGraph setNoJustify(boolean flag) {
        this.getAttrs().set(Attrs.Key.nojustify, flag);
        return this;
    }

    public ClusterGraph setPenColor(String color) {
        this.getAttrs().set(Attrs.Key.pencolor, color);
        return this;
    }

    public ClusterGraph setPenColor(Color.X11 color) {
        this.getAttrs().set(Attrs.Key.pencolor, (Object)color);
        return this;
    }

    public ClusterGraph setPenColor(Color.SVG color) {
        this.getAttrs().set(Attrs.Key.pencolor, (Object)color);
        return this;
    }

    public ClusterGraph setPenWidth(double val) {
        this.getAttrs().set(Attrs.Key.penwidth, val);
        return this;
    }

    public ClusterGraph setPeripheries(int val) {
        this.getAttrs().set(Attrs.Key.peripheries, val);
        return this;
    }

    public ClusterGraph setSortV(int val) {
        this.getAttrs().set(Attrs.Key.sortv, val);
        return this;
    }

    public ClusterGraph setStyle(Style.ClusterGraph style) {
        this.getAttrs().set(Attrs.Key.style, (Object)style);
        return this;
    }

    public ClusterGraph setTarget(String val) {
        this.getAttrs().set(Attrs.Key.target, val);
        return this;
    }

    public ClusterGraph setToolTip(String val) {
        this.getAttrs().set(Attrs.Key.tooltip, val);
        return this;
    }
}

