/*
 * Decompiled with CFR 0.152.
 */
package info.leadinglight.jdot;

import info.leadinglight.jdot.Graph;
import info.leadinglight.jdot.Node;
import info.leadinglight.jdot.SubGraph;
import info.leadinglight.jdot.enums.ArrowType;
import info.leadinglight.jdot.enums.Color;
import info.leadinglight.jdot.enums.Dir;
import info.leadinglight.jdot.enums.GraphType;
import info.leadinglight.jdot.enums.Style;
import info.leadinglight.jdot.impl.AbstractElement;
import info.leadinglight.jdot.impl.AbstractGraph;
import info.leadinglight.jdot.impl.Attrs;
import info.leadinglight.jdot.impl.EdgeNode;
import info.leadinglight.jdot.impl.Util;
import java.util.ArrayList;
import java.util.List;

public class Edge
extends AbstractElement {
    private final List<AbstractElement> _elements = new ArrayList<AbstractElement>();
    private AbstractGraph _graph;

    public Edge() {
    }

    public Edge(String name, String ... names) {
        this._elements.add(new EdgeNode(name));
        for (String n : names) {
            this._elements.add(new EdgeNode(n));
        }
        this._graph = null;
    }

    public Edge setGraph(AbstractGraph g) {
        this._graph = g;
        return this;
    }

    public Edge addNode(String name) {
        return this.addNode(name, null);
    }

    public Edge addNode(String name, String label) {
        this._elements.add(new EdgeNode(name, label));
        return this;
    }

    public Edge addNodes(String name, String ... names) {
        SubGraph sg = new SubGraph();
        sg.addNode(new Node(name));
        for (String n : names) {
            sg.addNode(new Node(n));
        }
        this.addSubGraph(sg);
        return this;
    }

    public Edge addSubGraph(SubGraph graph) {
        this._elements.add(graph);
        return this;
    }

    public boolean isStyle() {
        return this._elements.isEmpty();
    }

    @Override
    public String toDot() {
        String dot;
        if (this.isStyle()) {
            dot = "edge";
        } else {
            ArrayList<String> l = new ArrayList<String>();
            for (AbstractElement e : this._elements) {
                l.add(e.toDot());
            }
            dot = this._graph instanceof Graph && ((Graph)this._graph).getType() == GraphType.graph ? Util.join(l, " -- ") : Util.join(l, " -> ");
        }
        dot = this.getAttrs().has() ? dot + " [" + this.getAttrs().getAsString() + "] " : dot + " ";
        return dot;
    }

    public Edge setURL(String url) {
        this.getAttrs().set(Attrs.Key.URL, url);
        return this;
    }

    public Edge setArrowHead(ArrowType arrowType) {
        this.getAttrs().set(Attrs.Key.arrowhead, (Object)arrowType);
        return this;
    }

    public Edge setArrowHead(String val) {
        this.getAttrs().set(Attrs.Key.arrowhead, val);
        return this;
    }

    public Edge setArrowSize(double size) {
        this.getAttrs().set(Attrs.Key.arrowsize, size);
        return this;
    }

    public Edge setArrowTail(ArrowType arrowType) {
        this.getAttrs().set(Attrs.Key.arrowtail, (Object)arrowType);
        return this;
    }

    public Edge setArrowTail(String val) {
        this.getAttrs().set(Attrs.Key.arrowtail, val);
        return this;
    }

    public Edge setColor(String color) {
        this.getAttrs().set(Attrs.Key.color, color);
        return this;
    }

    public Edge setColor(Color.X11 color) {
        this.getAttrs().set(Attrs.Key.color, (Object)color);
        return this;
    }

    public Edge setColor(Color.SVG color) {
        this.getAttrs().set(Attrs.Key.color, (Object)color);
        return this;
    }

    public Edge setColorScheme(String scheme) {
        this.getAttrs().set(Attrs.Key.colorscheme, scheme);
        return this;
    }

    public Edge setComment(String comment) {
        this.getAttrs().set(Attrs.Key.comment, comment);
        return this;
    }

    public Edge setConstraint(boolean constraint) {
        this.getAttrs().set(Attrs.Key.constraint, constraint);
        return this;
    }

    public Edge setDecorate(boolean decorate) {
        this.getAttrs().set(Attrs.Key.decorate, decorate);
        return this;
    }

    public Edge setDir(Dir dir) {
        this.getAttrs().set(Attrs.Key.dir, (Object)dir);
        return this;
    }

    public Edge setEdgeURL(String url) {
        this.getAttrs().set(Attrs.Key.edgeURL, url);
        return this;
    }

    public Edge setEdgeHref(String val) {
        this.getAttrs().set(Attrs.Key.edgehref, val);
        return this;
    }

    public Edge setEdgeTarget(String val) {
        this.getAttrs().set(Attrs.Key.edgetarget, val);
        return this;
    }

    public Edge setEdgeTooltip(String val) {
        this.getAttrs().set(Attrs.Key.edgetooltip, val);
        return this;
    }

    public Edge setFillColor(String color) {
        this.getAttrs().set(Attrs.Key.fillcolor, color);
        return this;
    }

    public Edge setFillColor(Color.X11 color) {
        this.getAttrs().set(Attrs.Key.fillcolor, (Object)color);
        return this;
    }

    public Edge setFillColor(Color.SVG color) {
        this.getAttrs().set(Attrs.Key.fillcolor, (Object)color);
        return this;
    }

    public Edge setFontColor(String fontcolor) {
        this.getAttrs().set(Attrs.Key.fontcolor, fontcolor);
        return this;
    }

    public Edge setFontColor(Color.X11 fontcolor) {
        this.getAttrs().set(Attrs.Key.fontcolor, (Object)fontcolor);
        return this;
    }

    public Edge setFontColor(Color.SVG fontcolor) {
        this.getAttrs().set(Attrs.Key.fontcolor, (Object)fontcolor);
        return this;
    }

    public Edge setFontName(String fontname) {
        this.getAttrs().set(Attrs.Key.fontname, fontname);
        return this;
    }

    public Edge setFontSize(double fontsize) {
        this.getAttrs().set(Attrs.Key.fontsize, new Double(fontsize));
        return this;
    }

    public Edge setHeadURL(String val) {
        this.getAttrs().set(Attrs.Key.headURL, val);
        return this;
    }

    public Edge setHeadLp(String val) {
        this.getAttrs().set(Attrs.Key.head_lp, val);
        return this;
    }

    public Edge setHeadClip(boolean flag) {
        this.getAttrs().set(Attrs.Key.headclip, flag);
        return this;
    }

    public Edge setHeadHref(String val) {
        this.getAttrs().set(Attrs.Key.headhref, val);
        return this;
    }

    public Edge setHeadLabel(String label) {
        this.getAttrs().set(Attrs.Key.headlabel, label);
        return this;
    }

    public Edge setHeadPort(String val) {
        this.getAttrs().set(Attrs.Key.headport, val);
        return this;
    }

    public Edge setHeadTarget(String val) {
        this.getAttrs().set(Attrs.Key.headtarget, val);
        return this;
    }

    public Edge setHeadTooltip(String val) {
        this.getAttrs().set(Attrs.Key.headtooltip, val);
        return this;
    }

    public Edge setHref(String val) {
        this.getAttrs().set(Attrs.Key.href, val);
        return this;
    }

    public Edge setId(String val) {
        this.getAttrs().set(Attrs.Key.id, val);
        return this;
    }

    public Edge setLabel(String val) {
        this.getAttrs().set(Attrs.Key.label, val);
        return this;
    }

    public Edge setLabelUrl(String val) {
        this.getAttrs().set(Attrs.Key.labelURL, val);
        return this;
    }

    public Edge setLabelAngle(double val) {
        this.getAttrs().set(Attrs.Key.labelangle, val);
        return this;
    }

    public Edge setLabelDistance(double val) {
        this.getAttrs().set(Attrs.Key.labeldistance, val);
        return this;
    }

    public Edge setLabelFloat(boolean flag) {
        this.getAttrs().set(Attrs.Key.labelfloat, flag);
        return this;
    }

    public Edge setLabelFontColor(String fontcolor) {
        this.getAttrs().set(Attrs.Key.labelfontcolor, fontcolor);
        return this;
    }

    public Edge setLabelFontColor(Color.X11 fontcolor) {
        this.getAttrs().set(Attrs.Key.labelfontcolor, (Object)fontcolor);
        return this;
    }

    public Edge setLabelFontColor(Color.SVG fontcolor) {
        this.getAttrs().set(Attrs.Key.labelfontcolor, (Object)fontcolor);
        return this;
    }

    public Edge setLabelFontName(String fontname) {
        this.getAttrs().set(Attrs.Key.labelfontname, fontname);
        return this;
    }

    public Edge setLabelFontSize(double val) {
        this.getAttrs().set(Attrs.Key.labelfontsize, val);
        return this;
    }

    public Edge setLabelHref(String val) {
        this.getAttrs().set(Attrs.Key.labelhref, val);
        return this;
    }

    public Edge setLabelTarget(String val) {
        this.getAttrs().set(Attrs.Key.labeltarget, val);
        return this;
    }

    public Edge setLabelTooltip(String val) {
        this.getAttrs().set(Attrs.Key.labeltooltip, val);
        return this;
    }

    public Edge setLayer(String val) {
        this.getAttrs().set(Attrs.Key.layer, val);
        return this;
    }

    public Edge setLen(double val) {
        this.getAttrs().set(Attrs.Key.len, val);
        return this;
    }

    public Edge setLHead(String val) {
        this.getAttrs().set(Attrs.Key.lhead, val);
        return this;
    }

    public Edge setLp(String val) {
        this.getAttrs().set(Attrs.Key.lp, val);
        return this;
    }

    public Edge setTail(String val) {
        this.getAttrs().set(Attrs.Key.ltail, val);
        return this;
    }

    public Edge setMinLen(int len) {
        this.getAttrs().set(Attrs.Key.minlen, len);
        return this;
    }

    public Edge setNoJustify(boolean flag) {
        this.getAttrs().set(Attrs.Key.nojustify, flag);
        return this;
    }

    public Edge setPenWidth(double val) {
        this.getAttrs().set(Attrs.Key.penwidth, val);
        return this;
    }

    public Edge setPos(String val) {
        this.getAttrs().set(Attrs.Key.pos, val);
        return this;
    }

    public Edge setSameHead(String ahead) {
        this.getAttrs().set(Attrs.Key.samehead, ahead);
        return this;
    }

    public Edge setSameTail(String atail) {
        this.getAttrs().set(Attrs.Key.sametail, atail);
        return this;
    }

    public Edge setShowBoxes(int val) {
        this.getAttrs().set(Attrs.Key.showboxes, val);
        return this;
    }

    public Edge setStyle(Style.Edge style) {
        this.getAttrs().set(Attrs.Key.style, (Object)style);
        return this;
    }

    public Edge setTailURL(String val) {
        this.getAttrs().set(Attrs.Key.tailURL, val);
        return this;
    }

    public Edge setTailLp(String val) {
        this.getAttrs().set(Attrs.Key.tail_lp, val);
        return this;
    }

    public Edge setTailClip(boolean flag) {
        this.getAttrs().set(Attrs.Key.tailclip, flag);
        return this;
    }

    public Edge setTailHref(String val) {
        this.getAttrs().set(Attrs.Key.tailhref, val);
        return this;
    }

    public Edge setTailLabel(String label) {
        this.getAttrs().set(Attrs.Key.taillabel, label);
        return this;
    }

    public Edge setTailPort(String val) {
        this.getAttrs().set(Attrs.Key.tailport, val);
        return this;
    }

    public Edge setTailTarget(String val) {
        this.getAttrs().set(Attrs.Key.tailtarget, val);
        return this;
    }

    public Edge setTailTooltip(String val) {
        this.getAttrs().set(Attrs.Key.tailtooltip, val);
        return this;
    }

    public Edge setTarget(String val) {
        this.getAttrs().set(Attrs.Key.target, val);
        return this;
    }

    public Edge setToolTip(String val) {
        this.getAttrs().set(Attrs.Key.tooltip, val);
        return this;
    }

    public Edge setWeight(int val) {
        this.getAttrs().set(Attrs.Key.weight, val);
        return this;
    }

    public Edge setWeight(double val) {
        this.getAttrs().set(Attrs.Key.weight, val);
        return this;
    }

    public Edge setXLabel(String val) {
        this.getAttrs().set(Attrs.Key.xlabel, val);
        return this;
    }

    public Edge setXlp(String val) {
        this.getAttrs().set(Attrs.Key.xlp, val);
        return this;
    }
}

