/*
 * Decompiled with CFR 0.152.
 */
package info.leadinglight.jdot;

import info.leadinglight.jdot.ClusterGraph;
import info.leadinglight.jdot.Edge;
import info.leadinglight.jdot.Node;
import info.leadinglight.jdot.SubGraph;
import info.leadinglight.jdot.enums.ClusterMode;
import info.leadinglight.jdot.enums.Color;
import info.leadinglight.jdot.enums.GraphType;
import info.leadinglight.jdot.enums.Ordering;
import info.leadinglight.jdot.enums.OutputMode;
import info.leadinglight.jdot.enums.Overlap;
import info.leadinglight.jdot.enums.PageDir;
import info.leadinglight.jdot.enums.Position;
import info.leadinglight.jdot.enums.QuadType;
import info.leadinglight.jdot.enums.Rankdir;
import info.leadinglight.jdot.enums.Ratio;
import info.leadinglight.jdot.enums.SmoothType;
import info.leadinglight.jdot.enums.Splines;
import info.leadinglight.jdot.enums.Style;
import info.leadinglight.jdot.impl.AbstractElement;
import info.leadinglight.jdot.impl.AbstractGraph;
import info.leadinglight.jdot.impl.Attrs;
import info.leadinglight.jdot.impl.Util;

public class Graph
extends AbstractGraph {
    private GraphType _type = GraphType.digraph;
    private boolean _strict = false;
    public static String DEFAULT_CMD = "/usr/local/bin/dot";
    public static String[] DEFAULT_BROWSER_CMD = new String[]{"open", "-a", "Google Chrome.app"};

    public Graph() {
    }

    public Graph(String name) {
        super(name);
    }

    @Override
    public Graph addNode(Node n) {
        super.addNode(n);
        return this;
    }

    @Override
    public Graph addNodes(Node ... nodes) {
        super.addNodes(nodes);
        return this;
    }

    @Override
    public Graph addEdge(Edge e) {
        super.addEdge(e);
        return this;
    }

    @Override
    public Graph addEdge(String name, String ... names) {
        super.addEdge(name, names);
        return this;
    }

    @Override
    public Graph addEdges(Edge ... edges) {
        super.addEdges(edges);
        return this;
    }

    public Graph addSubGraph(SubGraph subGraph) {
        super.addGraph(subGraph);
        return this;
    }

    public Graph addClusterGraph(ClusterGraph clusterGraph) {
        super.addGraph(clusterGraph);
        return this;
    }

    public Graph setType(GraphType type) {
        this._type = type;
        return this;
    }

    public GraphType getType() {
        return this._type;
    }

    public Graph setStrict(boolean strict) {
        this._strict = strict;
        return this;
    }

    public boolean isStrict() {
        return this._strict;
    }

    @Override
    public String toDot() {
        String dot = "";
        if (this.isStrict()) {
            dot = "strict ";
        }
        dot = dot + this._type.name();
        if (this.getName() != null && this.getName().length() > 0) {
            dot = dot + " " + this.getName();
        }
        dot = dot + " { ";
        if (this.getAttrs().has()) {
            dot = dot + "graph [" + this.getAttrs().getAsString() + "] ";
        }
        for (AbstractElement e : this.getElements()) {
            dot = dot + e.toDot();
        }
        dot = dot + "} ";
        return dot;
    }

    public String dot2svg() {
        return this.dot2svg(DEFAULT_CMD);
    }

    public String dot2svg(String cmd) {
        return this.dot2(cmd, "svg");
    }

    public String dot2(String format) {
        return this.dot2(DEFAULT_CMD, format);
    }

    public String dot2(String cmd, String format) {
        return Util.sh(new String[]{cmd, "-T" + format}, this.toDot());
    }

    public String dot2file(String format) {
        return this.dot2file(DEFAULT_CMD, format);
    }

    public String dot2file(String cmd, String format) {
        String out = this.dot2(cmd, format);
        return Util.toTempFile(out);
    }

    public void viewSvg() {
        this.view("svg");
    }

    public void view(String format) {
        this.view(DEFAULT_CMD, format, DEFAULT_BROWSER_CMD);
    }

    public void view(String cmd, String format, String[] browserCmd) {
        String filename = this.dot2file(cmd, format);
        Util.sh(Util.append(browserCmd, "file://" + filename));
    }

    public static String dot2out(String format, String dot) {
        return Graph.dot2out(DEFAULT_CMD, "svg", dot);
    }

    public static String dot2out(String cmd, String format, String dot) {
        return Util.sh(new String[]{cmd, "-T" + format}, dot);
    }

    public static void setDefaultCmd(String defaultCmd) {
        DEFAULT_CMD = defaultCmd;
    }

    public static void setDefaultBrowserCmd(String[] defaultBrowserCmd) {
        DEFAULT_BROWSER_CMD = defaultBrowserCmd;
    }

    public Graph setDamping(double damping) {
        this.getAttrs().set(Attrs.Key.Damping, damping);
        return this;
    }

    public Graph setK(double k) {
        this.getAttrs().set(Attrs.Key.K, k);
        return this;
    }

    public Graph setURL(String url) {
        this.getAttrs().set(Attrs.Key.URL, url);
        return this;
    }

    public Graph setAspect(double ratio) {
        this.getAttrs().set(Attrs.Key.aspect, Double.toString(ratio));
        return this;
    }

    public Graph setAspect(double ratio, int maxPass) {
        this.getAttrs().set(Attrs.Key.aspect, Double.toString(ratio) + "," + Integer.toString(maxPass));
        return this;
    }

    public Graph setBb(double llx, double lly, double urx, double ury) {
        this.getAttrs().set(Attrs.Key.bb, "\"" + Double.toString(llx) + "," + Double.toString(lly) + "," + Double.toString(urx) + "," + Double.toString(ury) + "\"");
        return this;
    }

    public Graph setBgColor(String color) {
        this.getAttrs().set(Attrs.Key.bgcolor, color);
        return this;
    }

    public Graph setBgColor(Color.X11 color) {
        this.getAttrs().set(Attrs.Key.bgcolor, (Object)color);
        return this;
    }

    public Graph setBgColor(Color.SVG color) {
        this.getAttrs().set(Attrs.Key.bgcolor, (Object)color);
        return this;
    }

    public Graph setCenter(boolean center) {
        this.getAttrs().set(Attrs.Key.center, center);
        return this;
    }

    public Graph setCharSet(String charset) {
        this.getAttrs().set(Attrs.Key.charset, charset);
        return this;
    }

    public Graph setClusterRank(ClusterMode mode) {
        this.getAttrs().set(Attrs.Key.clusterrank, (Object)mode);
        return this;
    }

    public Graph setColorScheme(String scheme) {
        this.getAttrs().set(Attrs.Key.colorscheme, scheme);
        return this;
    }

    public Graph setComment(String comment) {
        this.getAttrs().set(Attrs.Key.comment, comment);
        return this;
    }

    public Graph setCompound(boolean compound) {
        this.getAttrs().set(Attrs.Key.compound, compound);
        return this;
    }

    public Graph setConcentrate(boolean concentrate) {
        this.getAttrs().set(Attrs.Key.compound, concentrate);
        return this;
    }

    public Graph setDefaultDist(double dist) {
        this.getAttrs().set(Attrs.Key.defaultdist, dist);
        return this;
    }

    public Graph setDim(int dim) {
        this.getAttrs().set(Attrs.Key.dim, dim);
        return this;
    }

    public Graph setDimen(int dimen) {
        this.getAttrs().set(Attrs.Key.dimen, dimen);
        return this;
    }

    public Graph setDirEdgeConstraints(boolean flag) {
        this.getAttrs().set(Attrs.Key.diredgeconstraints, flag);
        return this;
    }

    public Graph setDirEdgeConstraints(String val) {
        this.getAttrs().set(Attrs.Key.diredgeconstraints, val);
        return this;
    }

    public Graph setDpi(double val) {
        this.getAttrs().set(Attrs.Key.dpi, val);
        return this;
    }

    public Graph setEpsilon(double val) {
        this.getAttrs().set(Attrs.Key.epsilon, val);
        return this;
    }

    public Graph setESep(double val) {
        this.getAttrs().set(Attrs.Key.esep, val);
        return this;
    }

    public Graph setESep(String val) {
        this.getAttrs().set(Attrs.Key.esep, val);
        return this;
    }

    public Graph setFontColor(String fontcolor) {
        this.getAttrs().set(Attrs.Key.fontcolor, fontcolor);
        return this;
    }

    public Graph setFontColor(Color.X11 fontcolor) {
        this.getAttrs().set(Attrs.Key.fontcolor, (Object)fontcolor);
        return this;
    }

    public Graph setFontColor(Color.SVG fontcolor) {
        this.getAttrs().set(Attrs.Key.fontcolor, (Object)fontcolor);
        return this;
    }

    public Graph setFontName(String fontname) {
        this.getAttrs().set(Attrs.Key.fontname, fontname);
        return this;
    }

    public Graph setFontNames(String val) {
        this.getAttrs().set(Attrs.Key.fontnames, val);
        return this;
    }

    public Graph setFontPath(String val) {
        this.getAttrs().set(Attrs.Key.fontpath, val);
        return this;
    }

    public Graph setFontSize(double fontsize) {
        this.getAttrs().set(Attrs.Key.fontsize, fontsize);
        return this;
    }

    public Graph setForceLabels(boolean flag) {
        this.getAttrs().set(Attrs.Key.forcelabels, flag);
        return this;
    }

    public Graph setGradientAngle(int val) {
        this.getAttrs().set(Attrs.Key.gradientangle, val);
        return this;
    }

    public Graph setHref(String val) {
        this.getAttrs().set(Attrs.Key.href, val);
        return this;
    }

    public Graph setId(String val) {
        this.getAttrs().set(Attrs.Key.id, val);
        return this;
    }

    public Graph setImagePath(String val) {
        this.getAttrs().set(Attrs.Key.imagepath, val);
        return this;
    }

    public Graph setLabel(String label) {
        this.getAttrs().set(Attrs.Key.label, label);
        return this;
    }

    public Graph setLabelScheme(int val) {
        this.getAttrs().set(Attrs.Key.label_scheme, val);
        return this;
    }

    public Graph setLabelJust(Position.X val) {
        this.getAttrs().set(Attrs.Key.labeljust, (Object)val);
        return this;
    }

    public Graph setLabelLoc(Position.Y val) {
        this.getAttrs().set(Attrs.Key.labelloc, (Object)val);
        return this;
    }

    public Graph setLandscape(boolean flag) {
        this.getAttrs().set(Attrs.Key.landscape, flag);
        return this;
    }

    public Graph setLayerListSep(String val) {
        this.getAttrs().set(Attrs.Key.layerlistsep, val);
        return this;
    }

    public Graph setLayers(String val) {
        this.getAttrs().set(Attrs.Key.layers, val);
        return this;
    }

    public Graph setLayerSelect(String val) {
        this.getAttrs().set(Attrs.Key.layerselect, val);
        return this;
    }

    public Graph setLayerSep(String val) {
        this.getAttrs().set(Attrs.Key.layersep, val);
        return this;
    }

    public Graph setLayout(String val) {
        this.getAttrs().set(Attrs.Key.layout, val);
        return this;
    }

    public Graph setLevels(int val) {
        this.getAttrs().set(Attrs.Key.levels, val);
        return this;
    }

    public Graph setLevelsGap(double val) {
        this.getAttrs().set(Attrs.Key.levelsgap, val);
        return this;
    }

    public Graph setLHeight(double val) {
        this.getAttrs().set(Attrs.Key.lheight, val);
        return this;
    }

    public Graph setLp(String val) {
        this.getAttrs().set(Attrs.Key.lp, val);
        return this;
    }

    public Graph setLWidth(double val) {
        this.getAttrs().set(Attrs.Key.lwidth, val);
        return this;
    }

    public Graph setMargin(double val) {
        this.getAttrs().set(Attrs.Key.margin, val);
        return this;
    }

    public Graph setMargin(String val) {
        this.getAttrs().set(Attrs.Key.margin, val);
        return this;
    }

    public Graph setMaxiter(int val) {
        this.getAttrs().set(Attrs.Key.maxiter, val);
        return this;
    }

    public Graph setMclimit(double val) {
        this.getAttrs().set(Attrs.Key.mclimit, val);
        return this;
    }

    public Graph setMinDist(double val) {
        this.getAttrs().set(Attrs.Key.mindist, val);
        return this;
    }

    public Graph setMode(String val) {
        this.getAttrs().set(Attrs.Key.mode, val);
        return this;
    }

    public Graph setModel(String val) {
        this.getAttrs().set(Attrs.Key.model, val);
        return this;
    }

    public Graph setMosek(boolean flag) {
        this.getAttrs().set(Attrs.Key.mosek, flag);
        return this;
    }

    public Graph setNodeSep(double nodesep) {
        this.getAttrs().set(Attrs.Key.nodesep, nodesep);
        return this;
    }

    public Graph setNoJustify(boolean flag) {
        this.getAttrs().set(Attrs.Key.nojustify, flag);
        return this;
    }

    public Graph setNormalize(boolean flag) {
        this.getAttrs().set(Attrs.Key.normalize, flag);
        return this;
    }

    public Graph setNsLimit(double val) {
        this.getAttrs().set(Attrs.Key.nslimit, val);
        return this;
    }

    public Graph setNsLimit1(double val) {
        this.getAttrs().set(Attrs.Key.nslimit1, val);
        return this;
    }

    public Graph setOrdering(Ordering ordering) {
        this.getAttrs().set(Attrs.Key.ordering, (Object)ordering);
        return this;
    }

    public Graph setOrientation(String val) {
        this.getAttrs().set(Attrs.Key.orientation, val);
        return this;
    }

    public Graph setOutputOrder(OutputMode val) {
        this.getAttrs().set(Attrs.Key.outputorder, (Object)val);
        return this;
    }

    public Graph setOverlap(boolean overlap) {
        this.getAttrs().set(Attrs.Key.overlap, overlap);
        return this;
    }

    public Graph setOverlap(Overlap overlap) {
        this.getAttrs().set(Attrs.Key.overlap, (Object)overlap);
        return this;
    }

    public Graph setOverlapScaling(double val) {
        this.getAttrs().set(Attrs.Key.overlap_scaling, val);
        return this;
    }

    public Graph setPack(boolean flag) {
        this.getAttrs().set(Attrs.Key.pack, flag);
        return this;
    }

    public Graph setPack(int val) {
        this.getAttrs().set(Attrs.Key.pack, val);
        return this;
    }

    public Graph setPackMode(String val) {
        this.getAttrs().set(Attrs.Key.packmode, val);
        return this;
    }

    public Graph setPad(double val) {
        this.getAttrs().set(Attrs.Key.pad, val);
        return this;
    }

    public Graph setPad(String val) {
        this.getAttrs().set(Attrs.Key.pad, val);
        return this;
    }

    public Graph setPage(double val) {
        this.getAttrs().set(Attrs.Key.page, val);
        return this;
    }

    public Graph setPage(String val) {
        this.getAttrs().set(Attrs.Key.page, val);
        return this;
    }

    public Graph setPageDir(PageDir val) {
        this.getAttrs().set(Attrs.Key.pagedir, (Object)val);
        return this;
    }

    public Graph setQuadTree(QuadType val) {
        this.getAttrs().set(Attrs.Key.quadtree, (Object)val);
        return this;
    }

    public Graph setQuadTree(boolean flag) {
        this.getAttrs().set(Attrs.Key.quadtree, flag);
        return this;
    }

    public Graph setQuantum(double val) {
        this.getAttrs().set(Attrs.Key.quantum, val);
        return this;
    }

    public Graph setRankDir(Rankdir rankdir) {
        this.getAttrs().set(Attrs.Key.rankdir, (Object)rankdir);
        return this;
    }

    public Graph setRankSep(double amount) {
        return this.setRankSep(amount, false);
    }

    public Graph setRankSep(boolean equally) {
        return this.setRankSep(Double.MAX_VALUE, equally);
    }

    public Graph setRankSep(double amount, boolean equally) {
        if (equally) {
            if (amount != Double.MAX_VALUE) {
                this.getAttrs().set(Attrs.Key.ranksep, Double.toString(amount) + " equally");
            } else {
                this.getAttrs().set(Attrs.Key.ranksep, "equally");
            }
        } else if (amount != Double.MAX_VALUE) {
            this.getAttrs().set(Attrs.Key.ranksep, amount);
        }
        return this;
    }

    public Graph setRankSep(String val) {
        this.getAttrs().set(Attrs.Key.ranksep, val);
        return this;
    }

    public Graph setRatio(double ratio) {
        this.getAttrs().set(Attrs.Key.ratio, ratio);
        return this;
    }

    public Graph setRatio(Ratio ratio) {
        this.getAttrs().set(Attrs.Key.ratio, (Object)ratio);
        return this;
    }

    public Graph setReminCross(boolean flag) {
        this.getAttrs().set(Attrs.Key.remincross, flag);
        return this;
    }

    public Graph setRepulsiveForce(double val) {
        this.getAttrs().set(Attrs.Key.repulsiveforce, val);
        return this;
    }

    public Graph setResolution(double val) {
        this.getAttrs().set(Attrs.Key.resolution, val);
        return this;
    }

    public Graph setRoot(String val) {
        this.getAttrs().set(Attrs.Key.root, val);
        return this;
    }

    public Graph setRoot(boolean flag) {
        this.getAttrs().set(Attrs.Key.root, flag);
        return this;
    }

    public Graph setRotate(int val) {
        this.getAttrs().set(Attrs.Key.rotate, val);
        return this;
    }

    public Graph setRotation(double val) {
        this.getAttrs().set(Attrs.Key.rotation, val);
        return this;
    }

    public Graph setScale(double val) {
        this.getAttrs().set(Attrs.Key.scale, val);
        return this;
    }

    public Graph setScale(String val) {
        this.getAttrs().set(Attrs.Key.scale, val);
        return this;
    }

    public Graph setSearchSize(int val) {
        this.getAttrs().set(Attrs.Key.searchsize, val);
        return this;
    }

    public Graph setSep(String val) {
        this.getAttrs().set(Attrs.Key.sep, val);
        return this;
    }

    public Graph setShowBoxes(int val) {
        this.getAttrs().set(Attrs.Key.showboxes, val);
        return this;
    }

    public Graph setSize(String size) {
        this.getAttrs().set(Attrs.Key.size, size);
        return this;
    }

    public Graph setSize(double val) {
        this.getAttrs().set(Attrs.Key.size, val);
        return this;
    }

    public Graph setSmoothing(SmoothType val) {
        this.getAttrs().set(Attrs.Key.smoothing, (Object)val);
        return this;
    }

    public Graph setSortV(int val) {
        this.getAttrs().set(Attrs.Key.sortv, val);
        return this;
    }

    public Graph setSplines(Splines splines) {
        this.getAttrs().set(Attrs.Key.splines, (Object)splines);
        return this;
    }

    public Graph setSplines(boolean splines) {
        this.getAttrs().set(Attrs.Key.splines, splines);
        return this;
    }

    public Graph setStart(String val) {
        this.getAttrs().set(Attrs.Key.start, val);
        return this;
    }

    public Graph setStyle(Style.Graph style) {
        this.getAttrs().set(Attrs.Key.style, (Object)style);
        return this;
    }

    public Graph setStyleSheet(String val) {
        this.getAttrs().set(Attrs.Key.stylesheet, val);
        return this;
    }

    public Graph setTarget(String val) {
        this.getAttrs().set(Attrs.Key.target, val);
        return this;
    }

    public Graph setTrueColor(boolean val) {
        this.getAttrs().set(Attrs.Key.truecolor, val);
        return this;
    }

    public Graph setViewport(String val) {
        this.getAttrs().set(Attrs.Key.viewport, val);
        return this;
    }

    public Graph setVoroMargin(double val) {
        this.getAttrs().set(Attrs.Key.voro_margin, val);
        return this;
    }
}

