/*
 * Decompiled with CFR 0.152.
 */
package info.leadinglight.jdot;

import info.leadinglight.jdot.enums.Color;
import info.leadinglight.jdot.enums.Ordering;
import info.leadinglight.jdot.enums.Position;
import info.leadinglight.jdot.enums.Shape;
import info.leadinglight.jdot.enums.Style;
import info.leadinglight.jdot.impl.AbstractElement;
import info.leadinglight.jdot.impl.Attrs;

public class Node
extends AbstractElement {
    private final String _name;

    public Node() {
        this._name = "node";
    }

    public Node(String name) {
        this._name = name;
    }

    public boolean isStyle() {
        return this._name.equals("node");
    }

    public String getName() {
        return this._name;
    }

    @Override
    public String toDot() {
        String dot = "";
        dot = !this.isStyle() ? "\"" + this._name + "\"" : this._name;
        dot = this.getAttrs().has() ? dot + " [" + this.getAttrs().getAsString() + "] " : dot + " ";
        return dot;
    }

    public Node setURL(String url) {
        this.getAttrs().set(Attrs.Key.URL, url);
        return this;
    }

    public Node setArea(double area) {
        this.getAttrs().set(Attrs.Key.area, area);
        return this;
    }

    public Node setColor(String color) {
        this.getAttrs().set(Attrs.Key.color, color);
        return this;
    }

    public Node setColor(Color.X11 color) {
        this.getAttrs().set(Attrs.Key.color, (Object)color);
        return this;
    }

    public Node setColor(Color.SVG color) {
        this.getAttrs().set(Attrs.Key.color, (Object)color);
        return this;
    }

    public Node setColorScheme(String scheme) {
        this.getAttrs().set(Attrs.Key.colorscheme, scheme);
        return this;
    }

    public Node setComment(String comment) {
        this.getAttrs().set(Attrs.Key.comment, comment);
        return this;
    }

    public Node setDistortion(double val) {
        this.getAttrs().set(Attrs.Key.distortion, val);
        return this;
    }

    public Node setFillColor(String color) {
        this.getAttrs().set(Attrs.Key.fillcolor, color);
        return this;
    }

    public Node setFillColor(Color.X11 color) {
        this.getAttrs().set(Attrs.Key.fillcolor, (Object)color);
        return this;
    }

    public Node setFillColor(Color.SVG color) {
        this.getAttrs().set(Attrs.Key.fillcolor, (Object)color);
        return this;
    }

    public Node setFixedSize(boolean val) {
        this.getAttrs().set(Attrs.Key.fixedsize, val);
        return this;
    }

    public Node setFontColor(String fontcolor) {
        this.getAttrs().set(Attrs.Key.fontcolor, fontcolor);
        return this;
    }

    public Node setFontColor(Color.X11 fontcolor) {
        this.getAttrs().set(Attrs.Key.fontcolor, (Object)fontcolor);
        return this;
    }

    public Node setFontColor(Color.SVG fontcolor) {
        this.getAttrs().set(Attrs.Key.fontcolor, (Object)fontcolor);
        return this;
    }

    public Node setFontName(String fontname) {
        this.getAttrs().set(Attrs.Key.fontname, fontname);
        return this;
    }

    public Node setFontSize(double fontsize) {
        this.getAttrs().set(Attrs.Key.fontsize, fontsize);
        return this;
    }

    public Node setGradientAngle(int val) {
        this.getAttrs().set(Attrs.Key.gradientangle, val);
        return this;
    }

    public Node setGroup(String val) {
        this.getAttrs().set(Attrs.Key.group, val);
        return this;
    }

    public Node setHeight(double height) {
        this.getAttrs().set(Attrs.Key.height, height);
        return this;
    }

    public Node setHref(String val) {
        this.getAttrs().set(Attrs.Key.href, val);
        return this;
    }

    public Node setId(String val) {
        this.getAttrs().set(Attrs.Key.id, val);
        return this;
    }

    public Node setImage(String val) {
        this.getAttrs().set(Attrs.Key.image, val);
        return this;
    }

    public Node setImageScale(String val) {
        this.getAttrs().set(Attrs.Key.imagescale, val);
        return this;
    }

    public Node setImageScale(boolean flag) {
        this.getAttrs().set(Attrs.Key.imagescale, flag);
        return this;
    }

    public Node setLabel(String label) {
        this.getAttrs().set(Attrs.Key.label, label);
        return this;
    }

    public Node setLabelLoc(Position.Y val) {
        this.getAttrs().set(Attrs.Key.labelloc, (Object)val);
        return this;
    }

    public Node setLayer(String val) {
        this.getAttrs().set(Attrs.Key.layer, val);
        return this;
    }

    public Node setMargin(double val) {
        this.getAttrs().set(Attrs.Key.margin, val);
        return this;
    }

    public Node setMargin(String val) {
        this.getAttrs().set(Attrs.Key.margin, val);
        return this;
    }

    public Node setNoJustify(boolean flag) {
        this.getAttrs().set(Attrs.Key.nojustify, flag);
        return this;
    }

    public Node setOrdering(Ordering ordering) {
        this.getAttrs().set(Attrs.Key.ordering, (Object)ordering);
        return this;
    }

    public Node setOrientation(double val) {
        this.getAttrs().set(Attrs.Key.orientation, val);
        return this;
    }

    public Node setPenWidth(double val) {
        this.getAttrs().set(Attrs.Key.penwidth, val);
        return this;
    }

    public Node setPeripheries(int val) {
        this.getAttrs().set(Attrs.Key.peripheries, new Integer(val));
        return this;
    }

    public Node setPin(boolean flag) {
        this.getAttrs().set(Attrs.Key.pin, flag);
        return this;
    }

    public Node setPos(String val) {
        this.getAttrs().set(Attrs.Key.pos, val);
        return this;
    }

    public Node setRects(String val) {
        this.getAttrs().set(Attrs.Key.rects, val);
        return this;
    }

    public Node setRegular(boolean flag) {
        this.getAttrs().set(Attrs.Key.regular, flag);
        return this;
    }

    public Node setRoot(String val) {
        this.getAttrs().set(Attrs.Key.root, val);
        return this;
    }

    public Node setRoot(boolean flag) {
        this.getAttrs().set(Attrs.Key.root, flag);
        return this;
    }

    public Node setSamplePoints(int val) {
        this.getAttrs().set(Attrs.Key.samplepoints, val);
        return this;
    }

    public Node setShape(Shape shape) {
        this.getAttrs().set(Attrs.Key.shape, (Object)shape);
        return this;
    }

    public Node setShapeFile(String val) {
        this.getAttrs().set(Attrs.Key.shapefile, val);
        return this;
    }

    public Node setShowBoxes(int val) {
        this.getAttrs().set(Attrs.Key.showboxes, val);
        return this;
    }

    public Node setSides(int val) {
        this.getAttrs().set(Attrs.Key.sides, val);
        return this;
    }

    public Node setSkew(double val) {
        this.getAttrs().set(Attrs.Key.skew, val);
        return this;
    }

    public Node setSortV(int val) {
        this.getAttrs().set(Attrs.Key.sortv, val);
        return this;
    }

    public Node setStyle(Style.Node style) {
        this.getAttrs().set(Attrs.Key.style, (Object)style);
        return this;
    }

    public Node setTarget(String val) {
        this.getAttrs().set(Attrs.Key.target, val);
        return this;
    }

    public Node setToolTip(String val) {
        this.getAttrs().set(Attrs.Key.tooltip, val);
        return this;
    }

    public Node setVertices(String val) {
        this.getAttrs().set(Attrs.Key.vertices, val);
        return this;
    }

    public Node setWidth(double width) {
        this.getAttrs().set(Attrs.Key.width, width);
        return this;
    }

    public Node setXLabel(String val) {
        this.getAttrs().set(Attrs.Key.xlabel, val);
        return this;
    }

    public Node setXlp(String val) {
        this.getAttrs().set(Attrs.Key.xlp, val);
        return this;
    }

    public Node setZ(double val) {
        this.getAttrs().set(Attrs.Key.z, val);
        return this;
    }
}

