/*
 * Decompiled with CFR 0.152.
 */
package info.leadinglight.jdot;

import info.leadinglight.jdot.ClusterGraph;
import info.leadinglight.jdot.Edge;
import info.leadinglight.jdot.Node;
import info.leadinglight.jdot.enums.Ordering;
import info.leadinglight.jdot.enums.Rank;
import info.leadinglight.jdot.impl.AbstractElement;
import info.leadinglight.jdot.impl.AbstractGraph;
import info.leadinglight.jdot.impl.Attrs;

public class SubGraph
extends AbstractGraph {
    private Rank _rank = null;

    public SubGraph() {
    }

    public SubGraph(String name) {
        super(name);
    }

    @Override
    public SubGraph addNode(Node n) {
        super.addNode(n);
        return this;
    }

    @Override
    public SubGraph addNodes(Node ... nodes) {
        super.addNodes(nodes);
        return this;
    }

    @Override
    public SubGraph addEdge(Edge e) {
        super.addEdge(e);
        return this;
    }

    @Override
    public SubGraph addEdge(String name, String ... names) {
        super.addEdge(name, names);
        return this;
    }

    @Override
    public SubGraph addEdges(Edge ... edges) {
        super.addEdges(edges);
        return this;
    }

    public SubGraph addSubGraph(SubGraph subGraph) {
        super.addGraph(subGraph);
        return this;
    }

    public SubGraph addClusterGraph(ClusterGraph clusterGraph) {
        super.addGraph(clusterGraph);
        return this;
    }

    @Override
    public String toDot() {
        String dot = "";
        if (this.getName() != null && this.getName().length() > 0) {
            dot = dot + "subgraph " + this.getName() + " ";
        }
        dot = dot + "{ ";
        if (this.getAttrs().has()) {
            dot = dot + "graph [" + this.getAttrs().getAsString() + "] ";
        }
        if (this._rank != null) {
            dot = dot + "rank=" + (Object)((Object)this._rank) + " ";
        }
        for (AbstractElement e : this.getElements()) {
            dot = dot + e.toDot();
        }
        dot = dot + "} ";
        return dot;
    }

    public SubGraph setOrdering(Ordering ordering) {
        this.getAttrs().set(Attrs.Key.ordering, (Object)ordering);
        return this;
    }

    public SubGraph setRank(Rank rank) {
        this._rank = rank;
        return this;
    }
}

