/*
 * Decompiled with CFR 0.152.
 */
package info.leadinglight.jdot.impl;

import info.leadinglight.jdot.Edge;
import info.leadinglight.jdot.Node;
import info.leadinglight.jdot.impl.AbstractElement;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractGraph
extends AbstractElement {
    private final List<AbstractElement> _elements;
    private final String _name;

    public AbstractGraph() {
        this._name = null;
        this._elements = new ArrayList<AbstractElement>();
    }

    public AbstractGraph(String name) {
        this._name = name;
        this._elements = new ArrayList<AbstractElement>();
    }

    public String getName() {
        return this._name;
    }

    public List<AbstractElement> getElements() {
        return this._elements;
    }

    public AbstractGraph addNode(Node n) {
        this._elements.add(n);
        return this;
    }

    public AbstractGraph addNodes(Node ... nodes) {
        for (Node n : nodes) {
            this.addNode(n);
        }
        return this;
    }

    public Node getNode(String name) {
        return this.getNode(name, false);
    }

    public Node getNode(String name, boolean create) {
        for (AbstractElement e : this._elements) {
            Node n;
            if (e instanceof Node && ((Node)e).getName().equals(name)) {
                return (Node)e;
            }
            if (!(e instanceof AbstractGraph) || (n = ((AbstractGraph)e).getNodeOrNull(name)) == null) continue;
            return n;
        }
        if (create) {
            Node n = new Node(name);
            this.addNode(n);
            return n;
        }
        throw new RuntimeException("Node " + name + " not found.");
    }

    public Node getNodeOrNull(String name) {
        for (AbstractElement e : this._elements) {
            Node n;
            if (e instanceof Node && ((Node)e).getName().equals(name)) {
                return (Node)e;
            }
            if (!(e instanceof AbstractGraph) || (n = ((AbstractGraph)e).getNodeOrNull(name)) == null) continue;
            return n;
        }
        return null;
    }

    public boolean hasNode(String name) {
        return this.getNodeOrNull(name) != null;
    }

    public AbstractGraph addEdge(Edge e) {
        this._elements.add(e.setGraph(this));
        return this;
    }

    public AbstractGraph addEdge(String name, String ... names) {
        this.addEdge(new Edge(name, names).setGraph(this));
        return this;
    }

    public AbstractGraph addEdges(Edge ... edges) {
        for (Edge e : edges) {
            this.addEdge(e);
        }
        return this;
    }

    public AbstractGraph addGraph(AbstractGraph graph) {
        this._elements.add(graph);
        return this;
    }
}

