/*
 * Decompiled with CFR 0.152.
 */
package info.leadinglight.jdot.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;

public class Util {
    public static String join(List<String> l) {
        return Util.join(l, ", ");
    }

    public static String join(List<String> l, String sep) {
        int k = l.size();
        if (k == 0) {
            return null;
        }
        StringBuilder out = new StringBuilder();
        out.append(l.get(0));
        for (int x = 1; x < k; ++x) {
            out.append(sep).append(l.get(x));
        }
        return out.toString();
    }

    public static String[] append(String[] array, String item) {
        int N = array.length;
        array = Arrays.copyOf(array, N + 1);
        array[N] = item;
        return array;
    }

    public static String toTempFile(String content) {
        try {
            return Util.toFile(content, File.createTempFile("jdot", ".out"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toFile(String content, File file) {
        try {
            FileWriter w = new FileWriter(file);
            w.write(content);
            w.flush();
            w.close();
            return file.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String fromFile(File file) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(file));
            try {
                StringBuilder sb = new StringBuilder();
                String line = br.readLine();
                while (line != null) {
                    sb.append(line);
                    sb.append("\n");
                    line = br.readLine();
                }
                String string = sb.toString();
                return string;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                br.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String sh(String cmd) {
        return Util.sh(cmd, null);
    }

    public static String sh(String cmd, String input) {
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            StringReader in = input != null ? new StringReader(input) : new StringReader("");
            StringWriter out = new StringWriter();
            StringWriter err = new StringWriter();
            Util.communicate(p, in, out, err);
            return ((Object)out).toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String sh(String[] cmds) {
        return Util.sh(cmds, null);
    }

    public static String sh(String[] cmds, String input) {
        try {
            Process p = Runtime.getRuntime().exec(cmds);
            StringReader in = input != null ? new StringReader(input) : new StringReader("");
            StringWriter out = new StringWriter();
            StringWriter err = new StringWriter();
            Util.communicate(p, in, out, err);
            return ((Object)out).toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void communicate(Process process, Reader _in, final Writer out, final Writer err) {
        final BufferedReader in = new BufferedReader(_in);
        final BufferedReader stdOut = new BufferedReader(new InputStreamReader(process.getInputStream()));
        final BufferedReader stdErr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        final BufferedWriter stdIn = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));
        Thread t1 = new Thread(){

            @Override
            public void run() {
                try {
                    String line;
                    while ((line = stdOut.readLine()) != null) {
                        out.write(line + "\n");
                    }
                }
                catch (IOException e) {
                    throw new Error(e);
                }
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        t1.start();
        Thread t2 = new Thread(){

            @Override
            public void run() {
                try {
                    String line;
                    while ((line = stdErr.readLine()) != null) {
                        err.write(line + "\n");
                    }
                }
                catch (IOException e) {
                    throw new Error(e);
                }
                try {
                    err.flush();
                    err.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        t2.start();
        Thread t3 = new Thread(){

            @Override
            public void run() {
                try {
                    String line;
                    while ((line = in.readLine()) != null) {
                        stdIn.write(line + "\n");
                    }
                }
                catch (IOException e) {
                    throw new Error(e);
                }
                try {
                    stdIn.flush();
                    stdIn.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        t3.start();
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            throw new Error(e);
        }
        try {
            t1.join();
            t2.join();
            t3.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }
}

