/*
 * Decompiled with CFR 0.152.
 */
package info.michaelwittig.javaq.connector.impl;

import info.michaelwittig.javaq.connector.QConnectorError;
import info.michaelwittig.javaq.connector.QConnectorException;
import info.michaelwittig.javaq.connector.QConnectorSync;
import info.michaelwittig.javaq.connector.impl.QConnectorImpl;
import info.michaelwittig.javaq.connector.impl.cmd.ConnectorSyncCommand;
import info.michaelwittig.javaq.connector.impl.cmd.ConnectorSyncCommandFunction;
import info.michaelwittig.javaq.connector.impl.cmd.ConnectorSyncCommandQ;
import info.michaelwittig.javaq.connector.impl.cmd.ConnectorSyncCommandSelect;
import info.michaelwittig.javaq.query.Function;
import info.michaelwittig.javaq.query.Result;
import info.michaelwittig.javaq.query.Select;
import java.io.IOException;
import java.util.TimeZone;
import kx.c;

final class QConnectorSyncImpl
extends QConnectorImpl
implements QConnectorSync {
    private c c = null;

    protected QConnectorSyncImpl(String aHost, int aPort, boolean aReconnectOnError) {
        super(aHost, aPort, aReconnectOnError);
    }

    @Override
    public void connect() throws QConnectorException, QConnectorError {
        try {
            if (this.c != null) {
                throw new QConnectorError("Already connected");
            }
            this.c = new c(this.getHost(), this.getPort());
            this.c.tz = TimeZone.getTimeZone("UTC");
        }
        catch (c.KException e) {
            throw new QConnectorException("KException", e);
        }
        catch (IOException e) {
            throw new QConnectorException("Could not connect to " + this.getHost() + ":" + this.getPort(), e);
        }
    }

    @Override
    public void disconnect() throws QConnectorError {
        if (this.c == null) {
            throw new QConnectorError("Not connected");
        }
        try {
            this.c.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.c = null;
    }

    private Result cmd(ConnectorSyncCommand cmd) throws QConnectorException {
        return this.cmd(cmd, false);
    }

    private Result cmd(ConnectorSyncCommand cmd, boolean isReconnectAttemp) throws QConnectorException {
        if (!this.isConnected()) {
            try {
                this.connect();
            }
            catch (QConnectorError e) {
                // empty catch block
            }
        }
        try {
            return cmd.execute(this.c);
        }
        catch (IOException e) {
            if (!isReconnectAttemp && this.reconnectOnError()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                try {
                    this.disconnect();
                    this.connect();
                }
                catch (QConnectorError kxe) {
                    throw new QConnectorException("Can not reconnect", kxe);
                }
                return this.cmd(cmd, true);
            }
            throw new QConnectorException("Socket failed", e);
        }
        catch (c.KException e) {
            throw new QConnectorException("Q failed", e);
        }
    }

    @Override
    public Result execute(String q) throws QConnectorException {
        return this.cmd(new ConnectorSyncCommandQ(q));
    }

    @Override
    public Result select(Select select) throws QConnectorException {
        return this.cmd(new ConnectorSyncCommandSelect(select));
    }

    @Override
    public Result call(Function function) throws QConnectorException {
        return this.cmd(new ConnectorSyncCommandFunction(function));
    }

    @Override
    public boolean isConnected() {
        return this.c != null;
    }
}

