/*
 * Decompiled with CFR 0.152.
 */
package info.michaelwittig.javaq.query.impl;

import info.michaelwittig.javaq.query.Function;
import info.michaelwittig.javaq.query.value.Value;
import java.util.ArrayList;
import java.util.List;

public final class FunctionImpl
implements Function {
    private final String name;
    private final List<Value> params = new ArrayList<Value>();

    public FunctionImpl(String aName) {
        this.name = aName;
    }

    @Override
    public String toQ() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("[");
        boolean first = true;
        for (Value param : this.params) {
            if (!first) {
                sb.append(";");
            }
            first = false;
            sb.append(param.toQ());
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Value> getParams() {
        return this.params;
    }

    public static final class FunctionBuilderImpl
    implements Function.FunctionBuilder {
        private final FunctionImpl function;

        public FunctionBuilderImpl(String name) {
            this.function = new FunctionImpl(name);
        }

        @Override
        public Function.FunctionBuilder param(Value<?, ?> param) {
            this.function.params.add(param);
            return this;
        }

        @Override
        public Function build() {
            return this.function;
        }
    }
}

