/*
 * Decompiled with CFR 0.152.
 */
package info.michaelwittig.javaq.query.impl;

import info.michaelwittig.javaq.query.Select;
import info.michaelwittig.javaq.query.Table;
import info.michaelwittig.javaq.query.column.Column;
import info.michaelwittig.javaq.query.filter.Filter;
import info.michaelwittig.javaq.query.group.Group;
import java.util.ArrayList;
import java.util.List;

public final class SelectImpl
implements Select {
    private final Table table;
    private final List<Column<?>> columns = new ArrayList();
    private final List<Group> groups = new ArrayList<Group>();
    private final List<Filter> filters = new ArrayList<Filter>();
    private Integer numberOfRows;
    private Integer rowNumber;
    private Select.Sort sort;

    private SelectImpl(Table aTable) {
        this.table = aTable;
    }

    private void sortToQ(StringBuilder sb) {
        String sorting = this.numberOfRows != null && this.sort != null ? this.numberOfRows + ";" + this.sort.toQ() : (this.numberOfRows != null && this.rowNumber != null ? this.rowNumber + " " + this.numberOfRows : (this.numberOfRows != null ? String.valueOf(this.numberOfRows) : (this.sort != null ? this.sort.toQ() : null)));
        if (sorting != null) {
            sb.append("[");
            sb.append(sorting);
            sb.append("]");
        }
    }

    private void filterToQ(StringBuilder sb) {
        if (this.filters.size() > 0) {
            sb.append(" where ");
            for (Filter f : this.filters) {
                sb.append(f.toQ());
                sb.append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
        }
    }

    private void groupToQ(StringBuilder sb) {
        if (this.groups.size() > 0) {
            sb.append(" by ");
            for (Group g : this.groups) {
                sb.append(g.toQ());
                sb.append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
        }
    }

    @Override
    public String toQ() {
        StringBuilder sb = new StringBuilder("select");
        this.sortToQ(sb);
        sb.append(" ");
        for (Column<?> c2 : this.columns) {
            sb.append(c2.toQ());
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        this.groupToQ(sb);
        sb.append(" from ");
        sb.append(this.table.toQ());
        this.filterToQ(sb);
        return sb.toString();
    }

    @Override
    public List<Column<?>> getColumns() {
        return this.columns;
    }

    @Override
    public List<Group> getGroups() {
        return this.groups;
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    @Override
    public List<Filter> getFilters() {
        return this.filters;
    }

    @Override
    public Integer getNumberOfRows() {
        return this.numberOfRows;
    }

    @Override
    public Integer getRowNumber() {
        return this.rowNumber;
    }

    @Override
    public Select.Sort getSortColmn() {
        return this.sort;
    }

    public static final class SelectBuilderImpl
    implements Select.SelectBuilder {
        private final SelectImpl select;

        public SelectBuilderImpl(Table table) {
            this.select = new SelectImpl(table);
        }

        @Override
        public Select.SelectBuilder column(Column<?> column) {
            this.select.columns.add(column);
            return this;
        }

        @Override
        public Select.SelectBuilder group(Group group) {
            this.select.groups.add(group);
            return this;
        }

        @Override
        public Select.SelectBuilder filter(Filter filter) {
            this.select.filters.add(filter);
            return this;
        }

        @Override
        public Select.SelectBuilder limit(int numberOfRows) {
            this.select.numberOfRows = numberOfRows;
            return this;
        }

        @Override
        public Select.SelectBuilder start(int rowNumber) {
            this.select.rowNumber = rowNumber;
            return this;
        }

        @Override
        public Select.SelectBuilder order(final Select.Sort.Direction direction, final Column<?> column) {
            this.select.sort = new Select.Sort(){

                @Override
                public String toQ() {
                    return direction.toQ() + column.toQ();
                }

                @Override
                public Column<?> getColumn() {
                    return column;
                }

                @Override
                public Select.Sort.Direction getDirection() {
                    return direction;
                }
            };
            return this;
        }

        @Override
        public Select build() {
            return this.select;
        }
    }
}

