/*
 * Decompiled with CFR 0.152.
 */
package info.michaelwittig.javaq.query.type.impl;

import info.michaelwittig.javaq.query.type.OrdinalType;
import info.michaelwittig.javaq.query.type.Type;
import info.michaelwittig.javaq.query.type.ValueFactory;
import info.michaelwittig.javaq.query.value.Value;
import info.michaelwittig.javaq.query.value.impl.FloatValue;
import java.math.BigDecimal;

public final class TypeFloat
implements OrdinalType<BigDecimal> {
    private static final TypeFloat INSTANCE = new TypeFloat();

    public static TypeFloat get() {
        return INSTANCE;
    }

    @Override
    public ValueFactory<BigDecimal, Type<BigDecimal>> geValueFactory() {
        return new ValueFactory<BigDecimal, Type<BigDecimal>>(){

            @Override
            public Value<BigDecimal, ? extends Type<BigDecimal>> create(BigDecimal value) {
                return FloatValue.from(value);
            }

            @Override
            public Value<BigDecimal, ? extends Type<BigDecimal>> fromQ(Object value) {
                if (value == null) {
                    return this.create(null);
                }
                if (value instanceof Float) {
                    return this.create(new BigDecimal(((Float)value).floatValue()));
                }
                if (value instanceof Double) {
                    return this.create(new BigDecimal((Double)value));
                }
                throw new IllegalArgumentException("Type is " + value.getClass().getSimpleName());
            }
        };
    }

    private TypeFloat() {
    }
}

