/*
 * Decompiled with CFR 0.152.
 */
package info.michaelwittig.javaq.query.value.impl;

import info.michaelwittig.javaq.query.type.Type;
import info.michaelwittig.javaq.query.type.impl.TypeDateTime;
import info.michaelwittig.javaq.query.type.impl.TypeList;
import info.michaelwittig.javaq.query.value.impl.AValue;
import info.michaelwittig.javaq.query.value.impl.ListValue;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.TimeZone;

public final class DateTimeValue
extends AValue<Date, TypeDateTime> {
    public static final String NULL = "0Nz";

    public static DateTimeValue from(Date value) {
        if (value == null) {
            return new DateTimeValue(value, TypeDateTime.get());
        }
        long offset = TimeZone.getDefault().getOffset(value.getTime());
        return new DateTimeValue(new Date(value.getTime() - offset), TypeDateTime.get());
    }

    public static ListValue<Date, TypeList<Date, Type<Date>>> froms(Date[] values) {
        return new ListValue<Date, TypeList<Date, Type<Date>>>(values, TypeList.getDateTime());
    }

    public static ListValue<Date, TypeList<Date, Type<Date>>> froms(Collection<Date> values) {
        return new ListValue<Date, TypeList<Date, Type<Date>>>(values.toArray(new Date[values.size()]), TypeList.getDateTime());
    }

    private DateTimeValue(Date value, TypeDateTime type) {
        super(value, type);
    }

    @Override
    public String toQ() {
        if (this.get() == null) {
            return NULL;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd'T'HH:mm:ss.SSS");
        return sdf.format((Date)this.get());
    }
}

