/*
 * Decompiled with CFR 0.152.
 */
package info.michaelwittig.javaq.query.value.impl;

import info.michaelwittig.javaq.query.type.Type;
import info.michaelwittig.javaq.query.type.impl.TypeList;
import info.michaelwittig.javaq.query.value.Value;
import info.michaelwittig.javaq.query.value.impl.AValue;
import java.util.ArrayList;

public class ListValue<J, T extends TypeList<J, Type<J>>>
extends AValue<J[], T> {
    private final ArrayList<Value<J, ? extends Type<J>>> values;

    public ListValue(J[] aValue, T aType) {
        super(aValue, aType);
        if (aValue != null) {
            this.values = new ArrayList();
            for (J value : aValue) {
                this.values.add(((TypeList)aType).getItemType().geValueFactory().create(value));
            }
        } else {
            this.values = null;
        }
    }

    @Override
    public final String toQ() {
        StringBuilder sb = new StringBuilder();
        if (this.values != null) {
            sb.append("(");
            if (this.values.size() > 0) {
                for (Value<J, Type<J>> value : this.values) {
                    sb.append(value.toQ());
                    sb.append(",");
                }
                sb.deleteCharAt(sb.length() - 1);
            }
            sb.append(")");
        } else {
            sb.append("()");
        }
        return sb.toString();
    }
}

