/*
 * Decompiled with CFR 0.152.
 */
package info.michaelwittig.javaq.query.value.impl;

import info.michaelwittig.javaq.query.type.Type;
import info.michaelwittig.javaq.query.type.impl.TypeList;
import info.michaelwittig.javaq.query.type.impl.TypeTime;
import info.michaelwittig.javaq.query.value.impl.AValue;
import info.michaelwittig.javaq.query.value.impl.ListValue;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.TimeZone;

public final class TimeValue
extends AValue<Time, TypeTime> {
    public static final String NULL = "0Nt";
    public static final long SECONDS_TO_MILLIS = 1000L;
    public static final long MINUTES_TO_MILLIS = 60000L;
    public static final long HOURS_TO_MILLIS = 3600000L;

    public static TimeValue from(Time value) {
        if (value == null) {
            return new TimeValue(value, TypeTime.get());
        }
        long offset = TimeZone.getDefault().getOffset(value.getTime());
        return new TimeValue(new Time(value.getTime() - offset), TypeTime.get());
    }

    public static TimeValue from(int hours, int minutes, int seconds, int millis) {
        return TimeValue.from(new Time((long)hours * 3600000L + (long)minutes * 60000L + (long)seconds * 1000L + (long)millis));
    }

    public static ListValue<Time, TypeList<Time, Type<Time>>> froms(Time[] values) {
        return new ListValue<Time, TypeList<Time, Type<Time>>>(values, TypeList.getTime());
    }

    public static ListValue<Time, TypeList<Time, Type<Time>>> froms(Collection<Time> values) {
        return new ListValue<Time, TypeList<Time, Type<Time>>>(values.toArray(new Time[values.size()]), TypeList.getTime());
    }

    private TimeValue(Time value, TypeTime type) {
        super(value, type);
    }

    @Override
    public String toQ() {
        if (this.get() == null) {
            return NULL;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS");
        return sdf.format((Date)this.get());
    }
}

