/*
 * Decompiled with CFR 0.152.
 */
package info.michaelwittig.javaq.query.value.impl;

import info.michaelwittig.javaq.query.type.Type;
import info.michaelwittig.javaq.query.type.impl.TypeList;
import info.michaelwittig.javaq.query.type.impl.TypeTimestamp;
import info.michaelwittig.javaq.query.value.impl.AValue;
import info.michaelwittig.javaq.query.value.impl.ListValue;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public final class TimestampValue
extends AValue<Timestamp, TypeTimestamp> {
    public static final String NULL = "0Np";
    public static final int MICROS_TO_NANOS = 1000;
    public static final int MILLIS_TO_NANOS = 1000000;

    public static TimestampValue from(Date value) {
        return TimestampValue.from(new Timestamp(value.getTime()));
    }

    public static TimestampValue from(Timestamp value) {
        if (value == null) {
            return new TimestampValue(value, TypeTimestamp.get());
        }
        long offset = TimeZone.getDefault().getOffset(value.getTime());
        Timestamp timestamp = new Timestamp(value.getTime() - offset);
        timestamp.setNanos(value.getNanos());
        return new TimestampValue(timestamp, TypeTimestamp.get());
    }

    public static TimestampValue from(int years, int months, int days, int hours, int minutes, int seconds, int millis, int micros, int nanos) {
        GregorianCalendar cal = new GregorianCalendar(years, months - 1, days, hours, minutes, seconds);
        long offset = cal.getTimeZone().getOffset(cal.getTimeInMillis());
        Timestamp timestamp = new Timestamp(cal.getTimeInMillis() + offset);
        timestamp.setNanos(millis * 1000000 + micros * 1000 + nanos);
        return TimestampValue.from(timestamp);
    }

    public static ListValue<Timestamp, TypeList<Timestamp, Type<Timestamp>>> froms(Timestamp[] values) {
        return new ListValue<Timestamp, TypeList<Timestamp, Type<Timestamp>>>(values, TypeList.getTimestamp());
    }

    public static ListValue<Timestamp, TypeList<Timestamp, Type<Timestamp>>> froms(Collection<Timestamp> values) {
        return new ListValue<Timestamp, TypeList<Timestamp, Type<Timestamp>>>(values.toArray(new Timestamp[values.size()]), TypeList.getTimestamp());
    }

    private TimestampValue(Timestamp value, TypeTimestamp type) {
        super(value, type);
    }

    @Override
    public String toQ() {
        if (this.get() == null) {
            return NULL;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd");
        SimpleDateFormat sdf2 = new SimpleDateFormat("HH:mm:ss");
        DecimalFormat df = new DecimalFormat("000000000");
        return sdf.format((Date)this.get()) + "D" + sdf2.format((Date)this.get()) + "." + df.format(((Timestamp)this.get()).getNanos());
    }
}

