/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.micronaut.camunda.bpm.feature;

import info.novatec.micronaut.camunda.bpm.feature.Configuration;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.ApplicationEventListener;
import io.micronaut.core.util.StringUtils;
import io.micronaut.runtime.server.event.ServerStartupEvent;
import io.micronaut.transaction.SynchronousTransactionManager;
import java.sql.Connection;
import javax.inject.Singleton;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requires(property="camunda.admin-user.id")
public class AdminUserCreator
implements ApplicationEventListener<ServerStartupEvent> {
    private static final Logger log = LoggerFactory.getLogger(AdminUserCreator.class);
    protected final IdentityService identityService;
    protected final AuthorizationService authorizationService;
    protected final Configuration.AdminUser adminUser;
    protected final SynchronousTransactionManager<Connection> transactionManager;

    public AdminUserCreator(IdentityService identityService, AuthorizationService authorizationService, Configuration configuration, SynchronousTransactionManager<Connection> transactionManager) {
        this.identityService = identityService;
        this.authorizationService = authorizationService;
        this.adminUser = configuration.getAdminUser();
        this.transactionManager = transactionManager;
    }

    public void onApplicationEvent(ServerStartupEvent event) {
        this.transactionManager.executeWrite(transactionStatus -> {
            if (!this.userAlreadyExists(this.adminUser.getId())) {
                this.createUser();
                if (!this.adminGroupAlreadyExists()) {
                    this.createAdminGroup();
                }
                this.createAdminGroupAuthorizations();
                this.identityService.createMembership(this.adminUser.getId(), "camunda-admin");
                log.info("Created initial Admin User: {}", (Object)this.adminUser.getId());
            }
            return null;
        });
    }

    protected boolean userAlreadyExists(String userId) {
        return this.identityService.createUserQuery().userId(userId).singleResult() != null;
    }

    protected boolean adminGroupAlreadyExists() {
        return this.identityService.createGroupQuery().groupId("camunda-admin").count() > 0L;
    }

    protected void createUser() {
        User newUser = this.identityService.newUser(this.adminUser.getId());
        newUser.setPassword(this.adminUser.getPassword());
        newUser.setFirstName(this.adminUser.getFirstname().orElse(StringUtils.capitalize((String)this.adminUser.getId())));
        newUser.setLastName(this.adminUser.getLastname().orElse(StringUtils.capitalize((String)this.adminUser.getId())));
        newUser.setEmail(this.adminUser.getEmail().orElse(this.adminUser.getId() + "@localhost"));
        this.identityService.saveUser(newUser);
    }

    protected void createAdminGroup() {
        Group camundaAdminGroup = this.identityService.newGroup("camunda-admin");
        camundaAdminGroup.setName("Camunda Administrators");
        camundaAdminGroup.setType("SYSTEM");
        this.identityService.saveGroup(camundaAdminGroup);
    }

    protected void createAdminGroupAuthorizations() {
        for (Resources resource : Resources.values()) {
            if (this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"camunda-admin"}).resourceType((Resource)resource).resourceId("*").count() != 0L) continue;
            AuthorizationEntity groupAuth = new AuthorizationEntity(1);
            groupAuth.setGroupId("camunda-admin");
            groupAuth.setResource((Resource)resource);
            groupAuth.setResourceId("*");
            groupAuth.addPermission((Permission)Permissions.ALL);
            this.authorizationService.saveAuthorization((Authorization)groupAuth);
        }
    }
}

