/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.micronaut.camunda.bpm.feature;

import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.exceptions.DisabledBeanException;
import io.micronaut.http.server.netty.NettyHttpServer;
import io.micronaut.runtime.server.EmbeddedServer;
import io.micronaut.servlet.jetty.JettyServer;
import io.micronaut.servlet.tomcat.TomcatServer;
import io.micronaut.servlet.undertow.UndertowServer;
import io.undertow.Version;
import java.util.Map;
import java.util.Optional;
import javax.inject.Singleton;
import org.apache.catalina.util.ServerInfo;
import org.camunda.bpm.engine.impl.telemetry.dto.ApplicationServer;
import org.eclipse.jetty.util.Jetty;

@Factory
public class ApplicationServerFactory {
    protected final Optional<EmbeddedServer> embeddedServer;

    ApplicationServerFactory(Optional<EmbeddedServer> embeddedServer) {
        this.embeddedServer = embeddedServer;
    }

    @Singleton
    @Requires(classes={NettyHttpServer.class, io.netty.util.Version.class})
    public ApplicationServer nettyServerInfo() {
        this.assertEmbeddedServerIsActive(NettyHttpServer.class);
        return io.netty.util.Version.identify().entrySet().stream().min(Map.Entry.comparingByKey()).map(entry -> new ApplicationServer("netty-" + ((io.netty.util.Version)entry.getValue()).artifactVersion())).orElseThrow(() -> new DisabledBeanException("Version information is not available for Netty."));
    }

    @Singleton
    @Requires(classes={JettyServer.class, Jetty.class})
    public ApplicationServer jettyServerInfo() {
        this.assertEmbeddedServerIsActive(JettyServer.class);
        return new ApplicationServer("jetty/" + Jetty.VERSION);
    }

    @Singleton
    @Requires(classes={TomcatServer.class, ServerInfo.class})
    public ApplicationServer tomcatServerInfo() {
        this.assertEmbeddedServerIsActive(TomcatServer.class);
        return new ApplicationServer(ServerInfo.getServerInfo());
    }

    @Singleton
    @Requires(classes={UndertowServer.class, Version.class})
    public ApplicationServer undertowServerInfo() {
        this.assertEmbeddedServerIsActive(UndertowServer.class);
        return new ApplicationServer(Version.getFullVersionString());
    }

    protected void assertEmbeddedServerIsActive(Class<?> clazz) {
        if (!(this.embeddedServer.isPresent() && this.embeddedServer.get().isServer() && clazz.isAssignableFrom(this.embeddedServer.get().getClass()))) {
            throw new DisabledBeanException(clazz.getName() + " is in classpath but not the active embedded server!");
        }
    }
}

