/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.micronaut.camunda.bpm.feature;

import info.novatec.micronaut.camunda.bpm.feature.Configuration;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.ApplicationEventListener;
import io.micronaut.runtime.server.event.ServerStartupEvent;
import javax.inject.Singleton;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.filter.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requires(property="camunda.filter.create")
public class FilterAllTaskCreator
implements ApplicationEventListener<ServerStartupEvent> {
    private static final Logger log = LoggerFactory.getLogger(FilterAllTaskCreator.class);
    protected final ProcessEngine processEngine;
    protected final String filterName;

    public FilterAllTaskCreator(ProcessEngine processEngine, Configuration configuration) {
        this.processEngine = processEngine;
        this.filterName = configuration.getFilter().getCreate().orElseThrow(() -> new IllegalArgumentException("If property 'camunda.filter.create' is set it must have a value."));
    }

    public void onApplicationEvent(ServerStartupEvent event) {
        Filter filter = (Filter)this.processEngine.getFilterService().createFilterQuery().filterName(this.filterName).singleResult();
        if (filter == null) {
            filter = this.processEngine.getFilterService().newTaskFilter(this.filterName);
            this.processEngine.getFilterService().saveFilter(filter);
            log.info("Created new task filter: {}", (Object)this.filterName);
        }
    }
}

