/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.micronaut.camunda.bpm.feature;

import info.novatec.micronaut.camunda.bpm.feature.Configuration;
import info.novatec.micronaut.camunda.bpm.feature.rest.RestApp;
import info.novatec.micronaut.camunda.bpm.feature.webapp.AdminApp;
import info.novatec.micronaut.camunda.bpm.feature.webapp.CockpitApp;
import info.novatec.micronaut.camunda.bpm.feature.webapp.EngineRestApp;
import info.novatec.micronaut.camunda.bpm.feature.webapp.TasklistApp;
import info.novatec.micronaut.camunda.bpm.feature.webapp.WebappSecurityFilter;
import info.novatec.micronaut.camunda.bpm.feature.webapp.WelcomeApp;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import java.util.Collections;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Singleton;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.camunda.bpm.admin.impl.web.bootstrap.AdminContainerBootstrap;
import org.camunda.bpm.cockpit.impl.web.bootstrap.CockpitContainerBootstrap;
import org.camunda.bpm.engine.rest.filter.CacheControlFilter;
import org.camunda.bpm.engine.rest.filter.EmptyBodyFilter;
import org.camunda.bpm.engine.rest.security.auth.ProcessEngineAuthenticationFilter;
import org.camunda.bpm.tasklist.impl.web.bootstrap.TasklistContainerBootstrap;
import org.camunda.bpm.webapp.impl.engine.ProcessEnginesFilter;
import org.camunda.bpm.webapp.impl.security.auth.AuthenticationFilter;
import org.camunda.bpm.webapp.impl.security.filter.CsrfPreventionFilter;
import org.camunda.bpm.webapp.impl.security.filter.headersec.HttpHeaderSecurityFilter;
import org.camunda.bpm.webapp.impl.security.filter.util.HttpSessionMutexListener;
import org.camunda.bpm.welcome.impl.web.bootstrap.WelcomeContainerBootstrap;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class JettyServerCustomizer
implements BeanCreatedEventListener<Server> {
    private static final Logger log = LoggerFactory.getLogger(JettyServerCustomizer.class);
    protected final Configuration configuration;

    public JettyServerCustomizer(Configuration configuration) {
        this.configuration = configuration;
    }

    public Server onCreated(BeanCreatedEvent<Server> event) {
        Server jettyServer = (Server)event.getBean();
        ContextHandlerCollection contextHandlerCollection = new ContextHandlerCollection();
        contextHandlerCollection.addHandler(jettyServer.getHandler());
        if (this.configuration.getRest().isEnabled()) {
            ServletContextHandler restServletContextHandler = new ServletContextHandler();
            restServletContextHandler.setContextPath(this.configuration.getRest().getContextPath());
            restServletContextHandler.addServlet(new ServletHolder((Servlet)new ServletContainer((ResourceConfig)new RestApp())), "/*");
            if (this.configuration.getRest().isBasicAuthEnabled()) {
                FilterHolder filterHolder = new FilterHolder(ProcessEngineAuthenticationFilter.class);
                filterHolder.setInitParameter("authentication-provider", "org.camunda.bpm.engine.rest.security.auth.impl.HttpBasicAuthenticationProvider");
                restServletContextHandler.addFilter(filterHolder, "/*", EnumSet.of(DispatcherType.REQUEST));
                log.debug("REST API - Basic authentication enabled");
            }
            contextHandlerCollection.addHandler((Handler)restServletContextHandler);
            log.info("REST API initialized on {}/*", (Object)this.configuration.getRest().getContextPath());
        }
        if (this.configuration.getWebapps().isEnabled()) {
            ServletContextHandler webappsContextHandler = new ServletContextHandler();
            DefaultServlet defaultServlet = new DefaultServlet();
            ServletHolder webappsHolder = new ServletHolder("webapps", (Servlet)defaultServlet);
            webappsContextHandler.addServlet(webappsHolder, "/*");
            webappsContextHandler.setContextPath(this.configuration.getWebapps().getContextPath());
            Resource webappsResource = Resource.newClassPathResource((String)"/META-INF/resources/webjars/camunda");
            Resource pluginsResource = Resource.newClassPathResource((String)"/META-INF/resources");
            ResourceCollection resources = new ResourceCollection(new Resource[]{webappsResource, pluginsResource});
            webappsContextHandler.setBaseResource((Resource)resources);
            webappsContextHandler.addEventListener((EventListener)new CockpitContainerBootstrap());
            webappsContextHandler.addEventListener((EventListener)new AdminContainerBootstrap());
            webappsContextHandler.addEventListener((EventListener)new TasklistContainerBootstrap());
            webappsContextHandler.addEventListener((EventListener)new WelcomeContainerBootstrap());
            webappsContextHandler.addEventListener((EventListener)new HttpSessionMutexListener());
            webappsContextHandler.addEventListener((EventListener)((Object)new ServletContextInitializedListener(this.configuration)));
            webappsContextHandler.setSessionHandler(new SessionHandler());
            contextHandlerCollection.addHandler((Handler)webappsContextHandler);
            log.info("Webapps initialized on {}", (Object)this.configuration.getWebapps().getContextPath());
        }
        jettyServer.setHandler((Handler)contextHandlerCollection);
        return jettyServer;
    }

    static class ServletContextInitializedListener
    implements ServletContextListener {
        private static final Logger log = LoggerFactory.getLogger(ServletContextInitializedListener.class);
        protected static final EnumSet<DispatcherType> DISPATCHER_TYPES = EnumSet.of(DispatcherType.REQUEST);
        protected static ServletContext servletContext;
        protected final Configuration configuration;

        public ServletContextInitializedListener(Configuration configuration) {
            this.configuration = configuration;
        }

        public void contextInitialized(ServletContextEvent sce) {
            servletContext = sce.getServletContext();
            servletContext.addServlet("CockpitApp", (Servlet)new ServletContainer((ResourceConfig)new CockpitApp())).addMapping(new String[]{"/api/cockpit/*"});
            servletContext.addServlet("AdminApp", (Servlet)new ServletContainer((ResourceConfig)new AdminApp())).addMapping(new String[]{"/api/admin/*"});
            servletContext.addServlet("TasklistApp", (Servlet)new ServletContainer((ResourceConfig)new TasklistApp())).addMapping(new String[]{"/api/tasklist/*"});
            servletContext.addServlet("EngineRestApp", (Servlet)new ServletContainer((ResourceConfig)new EngineRestApp())).addMapping(new String[]{"/api/engine/*"});
            servletContext.addServlet("WelcomeApp", (Servlet)new ServletContainer((ResourceConfig)new WelcomeApp())).addMapping(new String[]{"/api/welcome/*"});
            this.registerFilter("ProcessEnginesFilter", ProcessEnginesFilter.class, "/api/*", "/app/*");
            this.registerFilter("AuthenticationFilter", AuthenticationFilter.class, "/api/*", "/app/*");
            this.registerFilter("SecurityFilter", WebappSecurityFilter.class, Collections.singletonMap("configFile", "/securityFilterRules.json"), "/api/*", "/app/*");
            this.registerFilter("CsrfPreventionFilter", CsrfPreventionFilter.class, this.getCsrfInitParams(), "/api/*", "/app/*");
            this.registerFilter("HttpHeaderSecurityFilter", HttpHeaderSecurityFilter.class, this.getHeaderSecurityInitParams(), "/api/*", "/app/*");
            this.registerFilter("EmptyBodyFilter", EmptyBodyFilter.class, "/api/*", "/app/*");
            this.registerFilter("CacheControlFilter", CacheControlFilter.class, "/api/*", "/app/*");
        }

        public void contextDestroyed(ServletContextEvent sce) {
        }

        protected Map<String, String> getCsrfInitParams() {
            HashMap<String, String> initParams = new HashMap<String, String>();
            this.configuration.getWebapps().getCsrf().getTargetOrigin().ifPresent(it -> initParams.put("targetOrigin", (String)it));
            this.configuration.getWebapps().getCsrf().getDenyStatus().ifPresent(it -> initParams.put("denyStatus", it.toString()));
            this.configuration.getWebapps().getCsrf().getRandomClass().ifPresent(it -> initParams.put("randomClass", (String)it));
            this.configuration.getWebapps().getCsrf().getEntryPoints().ifPresent(it -> initParams.put("entryPoints", String.join((CharSequence)",", it)));
            if (this.configuration.getWebapps().getCsrf().getEnableSecureCookie()) {
                initParams.put("enableSecureCookie", "true");
            }
            if (this.configuration.getWebapps().getCsrf().getEnableSameSiteCookie()) {
                this.configuration.getWebapps().getCsrf().getSameSiteCookieOption().ifPresent(it -> initParams.put("sameSiteCookieOption", (String)it));
                this.configuration.getWebapps().getCsrf().getSameSiteCookieValue().ifPresent(it -> initParams.put("sameSiteCookieValue", (String)it));
            } else {
                initParams.put("enableSameSiteCookie", "false");
            }
            this.configuration.getWebapps().getCsrf().getCookieName().ifPresent(it -> initParams.put("cookieName", (String)it));
            return initParams;
        }

        protected Map<String, String> getHeaderSecurityInitParams() {
            HashMap<String, String> initParams = new HashMap<String, String>();
            if (this.configuration.getWebapps().getHeaderSecurity().isXssProtectionDisabled()) {
                initParams.put("xssProtectionDisabled", "true");
            } else {
                this.configuration.getWebapps().getHeaderSecurity().getXssProtectionOption().ifPresent(it -> initParams.put("xssProtectionOption", (String)it));
                this.configuration.getWebapps().getHeaderSecurity().getXssProtectionValue().ifPresent(it -> initParams.put("xssProtectionValue", (String)it));
            }
            if (this.configuration.getWebapps().getHeaderSecurity().isContentSecurityPolicyDisabled()) {
                initParams.put("contentSecurityPolicyDisabled", "true");
            } else {
                this.configuration.getWebapps().getHeaderSecurity().getContentSecurityPolicyValue().ifPresent(it -> initParams.put("contentSecurityPolicyValue", (String)it));
            }
            if (this.configuration.getWebapps().getHeaderSecurity().isContentTypeOptionsDisabled()) {
                initParams.put("contentTypeOptionsDisabled", "true");
            } else {
                this.configuration.getWebapps().getHeaderSecurity().getContentTypeOptionsValue().ifPresent(it -> initParams.put("contentTypeOptionsValue", (String)it));
            }
            if (!this.configuration.getWebapps().getHeaderSecurity().isHstsDisabled()) {
                initParams.put("hstsDisabled", "false");
                this.configuration.getWebapps().getHeaderSecurity().getHstsMaxAge().ifPresent(it -> initParams.put("hstsMaxAge", it.toString()));
                if (!this.configuration.getWebapps().getHeaderSecurity().isHstsIncludeSubdomainsDisabled()) {
                    initParams.put("hstsIncludeSubdomainsDisabled", "false");
                }
                this.configuration.getWebapps().getHeaderSecurity().getHstsValue().ifPresent(it -> initParams.put("hstsValue", (String)it));
            }
            return initParams;
        }

        protected void registerFilter(String filterName, Class<? extends Filter> filterClass, String ... urlPatterns) {
            this.registerFilter(filterName, filterClass, (Map<String, String>)null, urlPatterns);
        }

        protected void registerFilter(String filterName, Class<? extends Filter> filterClass, Map<String, String> initParams, String ... urlPatterns) {
            FilterRegistration filterRegistration = servletContext.getFilterRegistration(filterName);
            if (filterRegistration == null) {
                filterRegistration = servletContext.addFilter(filterName, filterClass);
                filterRegistration.addMappingForUrlPatterns(DISPATCHER_TYPES, true, urlPatterns);
                if (initParams != null) {
                    filterRegistration.setInitParameters(initParams);
                }
                log.debug("Filter {} for URL {} registered", (Object)filterName, (Object)urlPatterns);
            }
        }
    }
}

