/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.micronaut.camunda.bpm.feature;

import info.novatec.micronaut.camunda.bpm.feature.CamundaVersion;
import info.novatec.micronaut.camunda.bpm.feature.Configuration;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.ApplicationEventListener;
import io.micronaut.runtime.server.event.ServerStartupEvent;
import java.net.URL;
import java.util.Scanner;
import javax.inject.Singleton;
import org.camunda.bpm.engine.ManagementService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requires(property="camunda.license-file")
public class LicenseKeyConfiguration
implements ApplicationEventListener<ServerStartupEvent> {
    private static final Logger log = LoggerFactory.getLogger(LicenseKeyConfiguration.class);
    protected static final String DEFAULT_LICENSE_FILE = "camunda-license.txt";
    protected static final String HEADER_FOOTER_REGEX = "(?i)[-\\s]*(BEGIN|END)\\s*(OPTIMIZE|CAMUNDA|CAMUNDA\\s*BPM)\\s*LICENSE\\s*KEY[-\\s]*";
    protected final Configuration configuration;
    protected final ManagementService managementService;
    protected final CamundaVersion camundaVersion;
    protected String licenseKey;

    public LicenseKeyConfiguration(Configuration configuration, ManagementService managementService, CamundaVersion camundaVersion) {
        this.configuration = configuration;
        this.managementService = managementService;
        this.camundaVersion = camundaVersion;
    }

    public void onApplicationEvent(ServerStartupEvent event) {
        if (!this.camundaVersion.isEnterprise()) {
            log.warn("You are not using the Camunda Enterprise Edition dependencies. The license is not needed and will be ignored.");
            return;
        }
        if (this.managementService.getLicenseKey() != null) {
            log.info("A license key is already registered and will be used. Please use the Camunda Cockpit to update it.");
            return;
        }
        this.licenseKey = this.configuration.getLicenseFile().isPresent() ? this.readLicenseKeyFromUrl(this.configuration.getLicenseFile().get()) : this.readLicenseKeyFromUrl(LicenseKeyConfiguration.class.getClassLoader().getResource(DEFAULT_LICENSE_FILE));
        if (this.licenseKey != null) {
            this.managementService.setLicenseKey(this.licenseKey);
            log.info("Registered new license key");
        } else {
            log.warn("Could not locate the referenced license key. The license can be registered in the Camunda Cockpit.");
        }
    }

    protected String readLicenseKeyFromUrl(URL licenseFileUrl) {
        try {
            Scanner scanner = new Scanner(licenseFileUrl.openStream(), "UTF-8").useDelimiter("\\A");
            if (scanner.hasNext()) {
                return scanner.next().replaceAll(HEADER_FOOTER_REGEX, "").replaceAll("\\n", "").trim();
            }
            return null;
        }
        catch (Exception e) {
            log.warn("Ignoring license file {}. Details: {}", (Object)licenseFileUrl, (Object)e.getMessage());
            return null;
        }
    }
}

