/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.micronaut.camunda.bpm.feature;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.Qualifier;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.naming.NameResolver;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.impl.scripting.engine.Resolver;
import org.camunda.bpm.engine.impl.scripting.engine.ResolverFactory;

@Singleton
public class MnBeansResolverFactory
implements ResolverFactory,
Resolver {
    protected final ApplicationContext applicationContext;
    protected Set<String> keySet;

    public MnBeansResolverFactory(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public boolean containsKey(Object key) {
        return key instanceof String && this.getKeySet().contains(key);
    }

    public Object get(Object key) {
        Qualifier qualifier;
        if (key instanceof String && this.applicationContext.containsBean(Object.class, qualifier = Qualifiers.byName((String)((String)key)))) {
            return this.applicationContext.getBean(Object.class, qualifier);
        }
        return null;
    }

    public Set<String> keySet() {
        return this.getKeySet();
    }

    public Resolver createResolver(VariableScope variableScope) {
        return this;
    }

    protected synchronized Set<String> getKeySet() {
        if (this.keySet == null) {
            this.keySet = this.applicationContext.getAllBeanDefinitions().stream().map(this::getBeanName).collect(Collectors.toSet());
        }
        return this.keySet;
    }

    protected String getBeanName(BeanDefinition<?> beanDefinition) {
        Optional beanQualifier = beanDefinition.getAnnotationMetadata().findDeclaredAnnotation(Named.class).flatMap(AnnotationValue::stringValue);
        return beanQualifier.orElseGet(() -> {
            if (beanDefinition instanceof NameResolver) {
                Optional resolvedName = ((NameResolver)beanDefinition).resolveName();
                return resolvedName.orElse(this.getBeanNameFromType(beanDefinition));
            }
            return this.getBeanNameFromType(beanDefinition);
        });
    }

    protected String getBeanNameFromType(BeanDefinition<?> beanDefinition) {
        String beanName = beanDefinition.getBeanType().getSimpleName();
        return Character.toLowerCase(beanName.charAt(0)) + beanName.substring(1);
    }
}

