/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.micronaut.camunda.bpm.feature;

import info.novatec.micronaut.camunda.bpm.feature.JobExecutorCustomizer;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import javax.inject.Named;
import javax.inject.Singleton;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;

@Singleton
public class MnJobExecutor
extends JobExecutor {
    protected final ExecutorService ioExecutor;

    public MnJobExecutor(@Named(value="io") ExecutorService ioExecutor, JobExecutorCustomizer jobExecutorCustomizer) {
        this.ioExecutor = ioExecutor;
        jobExecutorCustomizer.customize(this);
    }

    protected void startExecutingJobs() {
        this.startJobAcquisitionThread();
    }

    protected void stopExecutingJobs() {
        this.stopJobAcquisitionThread();
    }

    public void executeJobs(List<String> jobIds, ProcessEngineImpl processEngine) {
        try {
            this.ioExecutor.execute(this.getExecuteJobsRunnable(jobIds, processEngine));
        }
        catch (RejectedExecutionException e) {
            this.logRejectedExecution(processEngine, jobIds.size());
            this.rejectedJobsHandler.jobsRejected(jobIds, processEngine, (JobExecutor)this);
        }
    }
}

