/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.micronaut.camunda.bpm.feature;

import info.novatec.micronaut.camunda.bpm.feature.ApplicationContextElResolver;
import info.novatec.micronaut.camunda.bpm.feature.CamundaVersion;
import info.novatec.micronaut.camunda.bpm.feature.Configuration;
import info.novatec.micronaut.camunda.bpm.feature.MnArtifactFactory;
import info.novatec.micronaut.camunda.bpm.feature.MnBeansResolverFactory;
import info.novatec.micronaut.camunda.bpm.feature.MnExpressionManager;
import info.novatec.micronaut.camunda.bpm.feature.MnJobExecutor;
import info.novatec.micronaut.camunda.bpm.feature.MnTelemetryRegistry;
import info.novatec.micronaut.camunda.bpm.feature.ProcessEngineConfigurationCustomizer;
import info.novatec.micronaut.camunda.bpm.feature.tx.MnTransactionContextFactory;
import info.novatec.micronaut.camunda.bpm.feature.tx.MnTransactionInterceptor;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.env.Environment;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.jdbc.BasicJdbcConfiguration;
import io.micronaut.transaction.SynchronousTransactionManager;
import io.micronaut.transaction.TransactionDefinition;
import java.sql.Connection;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import javax.sql.DataSource;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEnginePlugin;
import org.camunda.bpm.engine.impl.interceptor.CommandContextInterceptor;
import org.camunda.bpm.engine.impl.interceptor.CommandCounterInterceptor;
import org.camunda.bpm.engine.impl.interceptor.CommandInterceptor;
import org.camunda.bpm.engine.impl.interceptor.LogInterceptor;
import org.camunda.bpm.engine.impl.interceptor.ProcessApplicationContextInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Introspected
public class MnProcessEngineConfiguration
extends ProcessEngineConfigurationImpl {
    private static final Logger log = LoggerFactory.getLogger(MnProcessEngineConfiguration.class);
    protected final SynchronousTransactionManager<Connection> transactionManager;
    protected final MnJobExecutor jobExecutor;
    protected final MnTelemetryRegistry telemetryRegistry;
    protected final MnBeansResolverFactory beansResolverFactory;
    protected final Environment environment;
    protected final CamundaVersion camundaVersion;
    protected final BasicJdbcConfiguration basicJdbcConfiguration;
    protected final List<ProcessEnginePlugin> plugins;

    public MnProcessEngineConfiguration(SynchronousTransactionManager<Connection> transactionManager, MnJobExecutor jobExecutor, Configuration configuration, MnTelemetryRegistry telemetryRegistry, Environment environment, CamundaVersion camundaVersion, ApplicationContext applicationContext, BasicJdbcConfiguration basicJdbcConfiguration, DataSource dataSource, MnArtifactFactory artifactFactory, MnBeansResolverFactory beansResolverFactory, List<ProcessEnginePlugin> plugins, ProcessEngineConfigurationCustomizer processEngineConfigurationCustomizer) {
        this.transactionManager = transactionManager;
        this.jobExecutor = jobExecutor;
        this.telemetryRegistry = telemetryRegistry;
        this.beansResolverFactory = beansResolverFactory;
        this.environment = environment;
        this.camundaVersion = camundaVersion;
        this.basicJdbcConfiguration = basicJdbcConfiguration;
        this.plugins = plugins;
        this.checkForDeprecatedConfiguration();
        this.setDataSource(dataSource);
        this.setTransactionsExternallyManaged(true);
        this.setExpressionManager(new MnExpressionManager(new ApplicationContextElResolver(applicationContext)));
        this.setArtifactFactory(artifactFactory);
        this.configureDefaultValues();
        this.applyGenericProperties(configuration);
        this.configureTelemetry();
        this.registerProcessEnginePlugins();
        processEngineConfigurationCustomizer.customize(this);
    }

    public ProcessEngine buildProcessEngine() {
        return (ProcessEngine)this.transactionManager.executeWrite(transactionStatus -> {
            log.info("Building process engine connected to {}", (Object)this.basicJdbcConfiguration.getUrl());
            Instant start = Instant.now();
            ProcessEngine processEngine = super.buildProcessEngine();
            log.info("Started process engine in {}ms", (Object)ChronoUnit.MILLIS.between(start, Instant.now()));
            return processEngine;
        });
    }

    protected void initTransactionContextFactory() {
        if (this.transactionContextFactory == null) {
            this.transactionContextFactory = new MnTransactionContextFactory(this.transactionManager);
        }
    }

    protected void initJobExecutor() {
        this.setJobExecutor(this.jobExecutor);
        super.initJobExecutor();
    }

    protected void initScripting() {
        super.initScripting();
        this.getResolverFactories().add(this.beansResolverFactory);
    }

    protected Collection<? extends CommandInterceptor> getDefaultCommandInterceptorsTxRequired() {
        return this.getCommandInterceptors(false);
    }

    protected Collection<? extends CommandInterceptor> getDefaultCommandInterceptorsTxRequiresNew() {
        return this.getCommandInterceptors(true);
    }

    protected List<CommandInterceptor> getCommandInterceptors(boolean requiresNew) {
        return Arrays.asList(new CommandInterceptor[]{new LogInterceptor(), new CommandCounterInterceptor((ProcessEngineConfigurationImpl)this), new ProcessApplicationContextInterceptor((ProcessEngineConfigurationImpl)this), new MnTransactionInterceptor(this.transactionManager, requiresNew ? TransactionDefinition.Propagation.REQUIRES_NEW : TransactionDefinition.Propagation.REQUIRED), new CommandContextInterceptor(this.commandContextFactory, (ProcessEngineConfigurationImpl)this, requiresNew)});
    }

    protected void checkForDeprecatedConfiguration() {
        if (!this.environment.getPropertyEntries("camunda.bpm").isEmpty()) {
            String msg = "All properties with the prefix 'camunda.bpm.*' have been renamed to 'camunda.*'. Please update your configuration!";
            log.error(msg);
            throw new IllegalArgumentException(msg);
        }
    }

    protected void configureTelemetry() {
        this.setTelemetryRegistry(this.telemetryRegistry);
        if (this.environment.getActiveNames().contains("test")) {
            this.setInitializeTelemetry(false);
            this.setTelemetryReporterActivate(false);
        } else if (Boolean.TRUE.equals(this.isInitializeTelemetry()) && this.isTelemetryReporterActivate() && !this.camundaVersion.getVersion().isPresent()) {
            log.warn("Disabling TelemetryReporter because required information 'Camunda Version' is not available.");
            this.setTelemetryReporterActivate(false);
        }
    }

    protected void configureDefaultValues() {
        this.setJobExecutorActivate(!this.environment.getActiveNames().contains("test"));
        this.setDatabaseSchemaUpdate("true");
    }

    protected void applyGenericProperties(Configuration configuration) {
        BeanIntrospection introspection = BeanIntrospection.getIntrospection(MnProcessEngineConfiguration.class);
        for (Map.Entry<String, Object> entry : configuration.getGenericProperties().getProperties().entrySet()) {
            BeanProperty property = (BeanProperty)introspection.getProperty(entry.getKey()).orElseThrow(() -> new RuntimeException("Invalid process engine property: " + (String)entry.getKey()));
            property.set((Object)this, this.resolveGenericPropertyValue(entry.getValue(), property.getType()));
        }
    }

    protected Object resolveGenericPropertyValue(Object value, Class<?> type) {
        if (type == Integer.TYPE) {
            return Integer.valueOf(String.valueOf(value));
        }
        if (type == Long.TYPE) {
            return Long.valueOf(String.valueOf(value));
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return Boolean.valueOf(String.valueOf(value));
        }
        if (type == String.class) {
            return String.valueOf(value);
        }
        return value;
    }

    public ProcessEngineConfigurationImpl setInitializeTelemetry(Boolean telemetryInitialized) {
        return super.setInitializeTelemetry(telemetryInitialized.booleanValue());
    }

    protected void registerProcessEnginePlugins() {
        log.info("Registering process engine plugins: {}", this.plugins);
        this.setProcessEnginePlugins(this.plugins);
    }
}

