/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.micronaut.camunda.bpm.feature;

import info.novatec.micronaut.camunda.bpm.feature.CamundaVersion;
import info.novatec.micronaut.camunda.bpm.feature.Configuration;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.Factory;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

@Factory
public class ProcessEngineFactory {
    public static final String MICRONAUT_AUTO_DEPLOYMENT_NAME = "MicronautAutoDeployment";
    private static final Logger log = LoggerFactory.getLogger(ProcessEngineFactory.class);
    protected PathMatchingResourcePatternResolver resourceLoader = new PathMatchingResourcePatternResolver();

    @Context
    @Bean(preDestroy="close")
    public ProcessEngine processEngine(ProcessEngineConfiguration processEngineConfiguration, CamundaVersion camundaVersion, Configuration configuration) throws IOException {
        if (camundaVersion.getVersion().isPresent()) {
            log.info("Camunda version: {}", (Object)camundaVersion.getVersion().get());
        } else {
            log.warn("The Camunda version cannot be determined. If you created a Fat/Uber/Shadow JAR then please consider using the Micronaut Application Plugin's 'dockerBuild' task to create a Docker image.");
        }
        ProcessEngine processEngine = processEngineConfiguration.buildProcessEngine();
        this.deployProcessModels(processEngine, configuration);
        return processEngine;
    }

    protected void deployProcessModels(ProcessEngine processEngine, Configuration configuration) throws IOException {
        List<String> locations = Arrays.asList(configuration.getLocations());
        log.info("Searching for models in the resources at configured locations: {}", locations);
        DeploymentBuilder builder = processEngine.getRepositoryService().createDeployment().name(MICRONAUT_AUTO_DEPLOYMENT_NAME).enableDuplicateFiltering(true);
        boolean deploy = false;
        for (String extension : Arrays.asList("dmn", "bpmn")) {
            for (String location : locations) {
                Resource[] models;
                String pattern = this.replacePrefix(location) + "/*." + extension;
                for (Resource model : models = this.resourceLoader.getResources(pattern)) {
                    builder.addInputStream(model.getFilename(), model.getInputStream());
                    log.info("Deploying model: {}{}", (Object)this.normalizedPath(location), (Object)model.getFilename());
                    deploy = true;
                }
            }
        }
        if (deploy) {
            builder.deploy();
        }
    }

    protected String replacePrefix(String location) {
        return location.replace("classpath:", "classpath*:");
    }

    protected String normalizedPath(String location) {
        if (location.endsWith(".")) {
            location = location.substring(0, location.length() - 1);
        }
        if (!location.endsWith("/") && !location.endsWith("classpath:")) {
            location = location + "/";
        }
        return location;
    }
}

