/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.micronaut.camunda.bpm.feature.webapp;

import info.novatec.micronaut.camunda.bpm.feature.MnProcessEngineConfiguration;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.ApplicationEventListener;
import io.micronaut.runtime.server.event.ServerStartupEvent;
import io.micronaut.transaction.SynchronousTransactionManager;
import java.sql.Connection;
import javax.inject.Singleton;
import org.camunda.bpm.cockpit.Cockpit;
import org.camunda.bpm.cockpit.CockpitRuntimeDelegate;
import org.camunda.bpm.cockpit.db.CommandExecutor;
import org.camunda.bpm.cockpit.impl.DefaultCockpitRuntimeDelegate;
import org.camunda.bpm.cockpit.impl.db.CommandExecutorImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requires(property="camunda.webapps.enabled", value="true")
public class CockpitRuntimeDelegateInitializer
implements ApplicationEventListener<ServerStartupEvent> {
    private static final Logger log = LoggerFactory.getLogger(CockpitRuntimeDelegateInitializer.class);
    protected final MnProcessEngineConfiguration processEngineConfiguration;
    protected final SynchronousTransactionManager<Connection> transactionManager;

    public CockpitRuntimeDelegateInitializer(MnProcessEngineConfiguration processEngineConfiguration, SynchronousTransactionManager<Connection> transactionManager) {
        this.processEngineConfiguration = processEngineConfiguration;
        this.transactionManager = transactionManager;
    }

    public void onApplicationEvent(ServerStartupEvent event) {
        CockpitRuntimeDelegate cockpitRuntimeDelegate = Cockpit.getRuntimeDelegate();
        Cockpit.setCockpitRuntimeDelegate((CockpitRuntimeDelegate)new DefaultCockpitRuntimeDelegate(){

            protected CommandExecutor createCommandExecutor(String processEngineName) {
                return new CommandExecutorImpl(CockpitRuntimeDelegateInitializer.this.processEngineConfiguration, this.getMappingFiles()){

                    public <T> T executeCommand(Command<T> command) {
                        return (T)CockpitRuntimeDelegateInitializer.this.transactionManager.executeWrite(transactionStatus -> {
                            Object result = super.executeCommand(command);
                            Connection connection = (Connection)CockpitRuntimeDelegateInitializer.this.transactionManager.getConnection();
                            if (connection.getAutoCommit()) {
                                log.debug("Switching JDBC Connection [{}] to manual commit", (Object)connection);
                                connection.setAutoCommit(false);
                            }
                            return result;
                        });
                    }
                };
            }
        });
        log.debug("Replaced CockpitRuntimeDelegate {} with {} to enable transactions for the Cockpit", (Object)cockpitRuntimeDelegate, (Object)Cockpit.getRuntimeDelegate());
    }
}

