/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.micronaut.camunda.bpm.feature.webapp;

import info.novatec.micronaut.camunda.bpm.feature.Configuration;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.ApplicationEventListener;
import io.micronaut.runtime.server.event.ServerStartupEvent;
import io.micronaut.servlet.jetty.JettyServer;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requires(missing={JettyServer.class})
public class JettyRuntimeMissing
implements ApplicationEventListener<ServerStartupEvent> {
    private static final Logger log = LoggerFactory.getLogger(JettyRuntimeMissing.class);
    protected final Configuration configuration;

    public JettyRuntimeMissing(Configuration configuration) {
        this.configuration = configuration;
    }

    public void onApplicationEvent(ServerStartupEvent event) {
        if (this.configuration.getWebapps().isEnabled()) {
            log.warn("Webapps are enabled via 'camunda.webapps.enabled' but they are not supported on the current server runtime. Please switch to Jetty, see https://github.com/camunda-community-hub/micronaut-camunda-bpm#camunda-rest-api-and-webapps");
        }
        if (this.configuration.getRest().isEnabled()) {
            log.warn("REST are enabled via 'camunda.rest.enabled' but it is not supported on the current server runtime. Please switch to Jetty, see https://github.com/camunda-community-hub/micronaut-camunda-bpm#camunda-rest-api-and-webapps");
        }
    }
}

