/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.micronaut.camunda.bpm.feature;

import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Context;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.convert.format.MapFormat;
import io.micronaut.core.naming.conventions.StringConvention;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.validation.constraints.NotNull;

@Context
@ConfigurationProperties(value="camunda")
public interface Configuration {
    @Bindable(defaultValue="classpath:.")
    public String[] getLocations();

    @NotNull
    public Webapps getWebapps();

    @NotNull
    public Rest getRest();

    @NotNull
    public AdminUser getAdminUser();

    @NotNull
    public Filter getFilter();

    @NotNull
    public GenericProperties getGenericProperties();

    @NotNull
    public Eventing getEventing();

    public Optional<URL> getLicenseFile();

    @Bindable(defaultValue="true")
    public boolean isTwoStageProcessEngine();

    @ConfigurationProperties(value="eventing")
    public static interface Eventing {
        @Bindable(defaultValue="false")
        public boolean isExecution();

        @Bindable(defaultValue="false")
        public boolean isTask();

        @Bindable(defaultValue="false")
        public boolean isHistory();
    }

    @ConfigurationProperties(value="rest")
    public static interface Rest {
        public static final String DEFAULT_AUTHENTICATION_PROVIDER = "org.camunda.bpm.engine.rest.security.auth.impl.HttpBasicAuthenticationProvider";

        @Bindable(defaultValue="false")
        public boolean isEnabled();

        @Bindable(defaultValue="/engine-rest")
        public String getContextPath();

        @Bindable(defaultValue="false")
        public boolean isBasicAuthEnabled();

        @Bindable(defaultValue="org.camunda.bpm.engine.rest.security.auth.impl.HttpBasicAuthenticationProvider")
        public String getAuthenticationProvider();
    }

    @ConfigurationProperties(value="webapps")
    public static interface Webapps {
        @Bindable(defaultValue="false")
        public boolean isEnabled();

        @Bindable(defaultValue="/camunda")
        public String getContextPath();

        public boolean isIndexRedirectEnabled();

        @NotNull
        public HeaderSecurity getHeaderSecurity();

        @NotNull
        public Csrf getCsrf();

        @ConfigurationProperties(value="csrf")
        public static interface Csrf {
            public Optional<String> getTargetOrigin();

            public Optional<Integer> getDenyStatus();

            public Optional<String> getRandomClass();

            public Optional<String[]> getEntryPoints();

            @Bindable(defaultValue="false")
            public boolean getEnableSecureCookie();

            @Bindable(defaultValue="true")
            public boolean getEnableSameSiteCookie();

            public Optional<String> getSameSiteCookieOption();

            public Optional<String> getSameSiteCookieValue();

            public Optional<String> getCookieName();
        }

        @ConfigurationProperties(value="headerSecurity")
        public static interface HeaderSecurity {
            @Bindable(defaultValue="false")
            public boolean isXssProtectionDisabled();

            public Optional<String> getXssProtectionOption();

            public Optional<String> getXssProtectionValue();

            @Bindable(defaultValue="false")
            public boolean isContentSecurityPolicyDisabled();

            public Optional<String> getContentSecurityPolicyValue();

            @Bindable(defaultValue="false")
            public boolean isContentTypeOptionsDisabled();

            public Optional<String> getContentTypeOptionsValue();

            @Bindable(defaultValue="true")
            public boolean isHstsDisabled();

            public Optional<Long> getHstsMaxAge();

            @Bindable(defaultValue="true")
            public boolean isHstsIncludeSubdomainsDisabled();

            public Optional<String> getHstsValue();
        }
    }

    @ConfigurationProperties(value="genericProperties")
    public static class GenericProperties {
        Map<String, Object> properties = new HashMap<String, Object>();

        public void setProperties(@MapFormat(transformation=MapFormat.MapTransformation.FLAT, keyFormat=StringConvention.CAMEL_CASE) Map<String, Object> properties) {
            this.properties = properties;
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }
    }

    @ConfigurationProperties(value="adminUser")
    public static interface AdminUser {
        public String getId();

        public String getPassword();

        public Optional<String> getFirstname();

        public Optional<String> getLastname();

        public Optional<String> getEmail();
    }

    @ConfigurationProperties(value="filter")
    public static interface Filter {
        public Optional<String> getCreate();
    }
}

