/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.micronaut.camunda.bpm.feature;

import jakarta.inject.Singleton;
import java.util.Optional;
import org.camunda.bpm.engine.impl.telemetry.TelemetryRegistry;
import org.camunda.bpm.engine.impl.telemetry.dto.ApplicationServerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MnTelemetryRegistry
extends TelemetryRegistry {
    private static final Logger log = LoggerFactory.getLogger(MnTelemetryRegistry.class);
    protected static final String INTEGRATION_NAME = "micronaut-camunda";

    public MnTelemetryRegistry(Optional<ApplicationServerImpl> applicationServer) {
        this.setCamundaIntegration(INTEGRATION_NAME);
        if (applicationServer.isPresent()) {
            log.info("Server runtime version: vendor={}, version={}", (Object)applicationServer.get().getVendor(), (Object)applicationServer.get().getVersion());
            this.setApplicationServer(applicationServer.get().getVersion());
        } else {
            log.warn("Unable to identify the application server for the telemetry data!");
        }
    }
}

