/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.micronaut.camunda.bpm.feature.eventing;

import info.novatec.micronaut.camunda.bpm.feature.Configuration;
import info.novatec.micronaut.camunda.bpm.feature.eventing.EventingPublisherPluginCondition;
import io.micronaut.context.annotation.Requires;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.bpmn.parser.BpmnParseListener;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEnginePlugin;
import org.camunda.bpm.engine.impl.history.handler.HistoryEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requires(condition=EventingPublisherPluginCondition.class)
public class EventingPublisherPlugin
implements ProcessEnginePlugin {
    private static final Logger log = LoggerFactory.getLogger(EventingPublisherPlugin.class);
    protected final BpmnParseListener publishDelegateParseListener;
    protected final HistoryEventHandler publishHistoryEventHandler;
    protected final boolean eventingTask;
    protected final boolean eventingExecution;
    protected final boolean eventingHistory;

    public EventingPublisherPlugin(BpmnParseListener publishDelegateParseListener, HistoryEventHandler publishHistoryEventHandler, Configuration configuration) {
        this.publishDelegateParseListener = publishDelegateParseListener;
        this.publishHistoryEventHandler = publishHistoryEventHandler;
        this.eventingTask = configuration.getEventing().isTask();
        this.eventingExecution = configuration.getEventing().isExecution();
        this.eventingHistory = configuration.getEventing().isHistory();
    }

    public void preInit(ProcessEngineConfigurationImpl processEngineConfiguration) {
        if (this.eventingTask || this.eventingExecution) {
            log.info("Initialized Micronaut Event Engine Plugin.");
            if (this.eventingTask) {
                log.info("Task events will be published as Micronaut Events.");
            } else {
                log.info("Task eventing is disabled via property.");
            }
            if (this.eventingExecution) {
                log.info("Execution events will be published as Micronaut Events.");
            } else {
                log.info("Execution eventing is disabled via property.");
            }
            if (processEngineConfiguration.getCustomPostBPMNParseListeners() == null) {
                processEngineConfiguration.setCustomPostBPMNParseListeners(new ArrayList());
            }
            processEngineConfiguration.getCustomPostBPMNParseListeners().add(this.publishDelegateParseListener);
        }
        if (this.eventingHistory) {
            log.info("History events will be published as Micronaut events.");
            processEngineConfiguration.getCustomHistoryEventHandlers().add(this.publishHistoryEventHandler);
        } else {
            log.info("History eventing is disabled via property.");
        }
    }

    public void postInit(ProcessEngineConfigurationImpl processEngineConfiguration) {
    }

    public void postProcessEngineBuild(ProcessEngine processEngine) {
    }
}

