/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.micronaut.camunda.bpm.feature.initialization;

import info.novatec.micronaut.camunda.bpm.feature.MnProcessEngineConfiguration;
import info.novatec.micronaut.camunda.bpm.feature.initialization.ParallelInitializationWithProcessEngine;
import io.micronaut.context.BeanProvider;
import io.micronaut.context.annotation.Requires;
import jakarta.inject.Singleton;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ibatis.session.Configuration;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requires(property="camunda.two-stage-process-engine", value="true", defaultValue="true")
public class BootstrapProcessEngineStage2
implements ParallelInitializationWithProcessEngine {
    private static final Logger log = LoggerFactory.getLogger(BootstrapProcessEngineStage2.class);
    private final BeanProvider<MnProcessEngineConfiguration> mnProcessEngineConfigurationBeanProvider;
    private final JobExecutor jobExecutor;

    public BootstrapProcessEngineStage2(BeanProvider<MnProcessEngineConfiguration> mnProcessEngineConfigurationBeanProvider, JobExecutor jobExecutor) {
        this.mnProcessEngineConfigurationBeanProvider = mnProcessEngineConfigurationBeanProvider;
        this.jobExecutor = jobExecutor;
    }

    @Override
    public void execute(ProcessEngine processEngine) {
        MnProcessEngineConfiguration mnProcessEngineConfiguration = (MnProcessEngineConfiguration)((Object)this.mnProcessEngineConfigurationBeanProvider.get());
        Configuration src = mnProcessEngineConfiguration.createConfigurationStage2();
        Configuration dest = mnProcessEngineConfiguration.getSqlSessionFactory().getConfiguration();
        AtomicInteger statements = new AtomicInteger(0);
        src.getMappedStatements().forEach(ms -> {
            if (!dest.hasStatement(ms.getId())) {
                dest.addMappedStatement(ms);
                statements.incrementAndGet();
            }
        });
        log.debug("Copied {} mapped statements. New total is {} mapped statements.", (Object)statements.get(), (Object)dest.getMappedStatements().size());
        this.startJobExecutor();
    }

    protected void startJobExecutor() {
        if (this.jobExecutor.isAutoActivate()) {
            this.jobExecutor.start();
        }
    }
}

