/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.micronaut.camunda.bpm.feature.initialization;

import info.novatec.micronaut.camunda.bpm.feature.Configuration;
import info.novatec.micronaut.camunda.bpm.feature.initialization.ParallelInitializationWithProcessEngine;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

@Singleton
public class DeployModelsExecutor
implements ParallelInitializationWithProcessEngine {
    private static final Logger log = LoggerFactory.getLogger(DeployModelsExecutor.class);
    public static final String MICRONAUT_AUTO_DEPLOYMENT_NAME = "MicronautAutoDeployment";
    protected final PathMatchingResourcePatternResolver resourceLoader = new PathMatchingResourcePatternResolver();
    protected final List<String> locations;

    public DeployModelsExecutor(Configuration configuration) {
        this.locations = Arrays.asList(configuration.getLocations());
    }

    @Override
    public void execute(ProcessEngine processEngine) throws IOException {
        this.deployProcessModels(processEngine.getRepositoryService());
    }

    protected void deployProcessModels(RepositoryService repositoryService) throws IOException {
        log.info("Searching for models in the resources at configured locations: {}", this.locations);
        DeploymentBuilder builder = repositoryService.createDeployment().name(MICRONAUT_AUTO_DEPLOYMENT_NAME).enableDuplicateFiltering(true);
        boolean deploy = false;
        for (String extension : Arrays.asList("dmn", "bpmn", "form")) {
            for (String location : this.locations) {
                Resource[] models;
                String pattern = this.replacePrefix(location) + "/*." + extension;
                for (Resource model : models = this.resourceLoader.getResources(pattern)) {
                    builder.addInputStream(model.getFilename(), model.getInputStream());
                    log.info("Deploying model: {}{}", (Object)this.normalizedPath(location), (Object)model.getFilename());
                    deploy = true;
                }
            }
        }
        if (deploy) {
            builder.deploy();
        }
    }

    protected String replacePrefix(String location) {
        return location.replace("classpath:", "classpath*:");
    }

    protected String normalizedPath(String location) {
        if (location.endsWith(".")) {
            location = location.substring(0, location.length() - 1);
        }
        if (!location.endsWith("/") && !location.endsWith("classpath:")) {
            location = location + "/";
        }
        return location;
    }
}

