/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.micronaut.camunda.bpm.feature.initialization;

import info.novatec.micronaut.camunda.bpm.feature.initialization.ParallelInitializationWithoutProcessEngine;
import io.micronaut.context.BeanProvider;
import io.micronaut.core.annotation.Order;
import io.micronaut.runtime.event.annotation.EventListener;
import io.micronaut.runtime.server.event.ServerStartupEvent;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.camunda.bpm.engine.ProcessEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class InitProcessEngineService {
    private static final Logger log = LoggerFactory.getLogger(InitProcessEngineService.class);
    protected final BeanProvider<ProcessEngine> processEngineBeanProvider;
    protected final Stream<ParallelInitializationWithoutProcessEngine> parallelInitializationWithoutStream;
    protected final ExecutorService executorService;

    public InitProcessEngineService(BeanProvider<ProcessEngine> processEngineBeanProvider, Stream<ParallelInitializationWithoutProcessEngine> parallelInitializationWithoutStream, @Named(value="scheduled") ExecutorService executorService) {
        this.processEngineBeanProvider = processEngineBeanProvider;
        this.parallelInitializationWithoutStream = parallelInitializationWithoutStream;
        this.executorService = executorService;
    }

    @Order(value=-100)
    @EventListener
    public void onEvent(ServerStartupEvent event) {
        List<Future> futures = this.parallelInitializationWithoutStream.map(initialization -> this.executorService.submit(this.executeParallelInitialization((ParallelInitializationWithoutProcessEngine)initialization))).collect(Collectors.toList());
        log.debug("Waiting for process engine to be available");
        this.processEngineBeanProvider.get();
        log.debug("Waiting for all parallel initializations to complete");
        futures.forEach(future -> {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException("Failed to start", e);
            }
        });
        log.debug("All parallel initializations are completed");
    }

    protected Callable<ParallelInitializationWithoutProcessEngine> executeParallelInitialization(ParallelInitializationWithoutProcessEngine parallelInitializationWithoutProcessEngine) {
        return () -> {
            Instant start = Instant.now();
            log.debug("Start {} (Does not require process engine)", (Object)parallelInitializationWithoutProcessEngine.getClass().getSimpleName());
            parallelInitializationWithoutProcessEngine.execute();
            log.debug("End without {} in {}ms", (Object)parallelInitializationWithoutProcessEngine.getClass().getSimpleName(), (Object)ChronoUnit.MILLIS.between(start, Instant.now()));
            return parallelInitializationWithoutProcessEngine;
        };
    }
}

