/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.micronaut.camunda.bpm.feature.initialization;

import info.novatec.micronaut.camunda.bpm.feature.initialization.ParallelInitializationWithProcessEngine;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.camunda.bpm.engine.ProcessEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ParallelInitializationService {
    private static final Logger log = LoggerFactory.getLogger(ParallelInitializationService.class);
    private final ExecutorService executorService;
    private final Stream<ParallelInitializationWithProcessEngine> parallelInitializations;

    public ParallelInitializationService(@Named(value="scheduled") ExecutorService executorService, Stream<ParallelInitializationWithProcessEngine> parallelInitializations) {
        this.executorService = executorService;
        this.parallelInitializations = parallelInitializations;
    }

    public void process(ProcessEngine processEngine) {
        List<Future> futures = this.parallelInitializations.map(initialization -> this.executorService.submit(this.executeParallelInitialization((ParallelInitializationWithProcessEngine)initialization, processEngine))).collect(Collectors.toList());
        futures.forEach(future -> {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException("Failed to start", e);
            }
        });
    }

    protected Callable<ParallelInitializationWithProcessEngine> executeParallelInitialization(ParallelInitializationWithProcessEngine parallelInitializationWithProcessEngine, ProcessEngine processEngine) {
        return () -> {
            Instant start = Instant.now();
            log.debug("Start {} (Requires process engine)", (Object)parallelInitializationWithProcessEngine.getClass().getSimpleName());
            parallelInitializationWithProcessEngine.execute(processEngine);
            log.debug("End {} in {}ms", (Object)parallelInitializationWithProcessEngine.getClass().getSimpleName(), (Object)ChronoUnit.MILLIS.between(start, Instant.now()));
            return parallelInitializationWithProcessEngine;
        };
    }
}

