/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.micronaut.camunda.bpm.feature.webapp;

import info.novatec.micronaut.camunda.bpm.feature.Configuration;
import info.novatec.micronaut.camunda.bpm.feature.initialization.ParallelInitializationWithoutProcessEngine;
import io.micronaut.context.annotation.Requires;
import io.micronaut.servlet.jetty.JettyServer;
import jakarta.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requires(missing={JettyServer.class})
public class JettyRuntimeMissing
implements ParallelInitializationWithoutProcessEngine {
    private static final Logger log = LoggerFactory.getLogger(JettyRuntimeMissing.class);
    protected final boolean webappsEnabled;
    protected final boolean restEnabled;

    public JettyRuntimeMissing(Configuration configuration) {
        this.webappsEnabled = configuration.getWebapps().isEnabled();
        this.restEnabled = configuration.getRest().isEnabled();
    }

    @Override
    public void execute() {
        if (this.webappsEnabled) {
            log.warn("Webapps are enabled via 'camunda.webapps.enabled' but they are not supported on the current server runtime. Please switch to Jetty, see https://github.com/camunda-community-hub/micronaut-camunda-platform-7#camunda-rest-api-and-webapps");
        }
        if (this.restEnabled) {
            log.warn("REST is enabled via 'camunda.rest.enabled' but it is not supported on the current server runtime. Please switch to Jetty, see https://github.com/camunda-community-hub/micronaut-camunda-platform-7#camunda-rest-api-and-webapps");
        }
    }
}

