/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.micronaut.camunda.bpm.feature.webapp;

import info.novatec.micronaut.camunda.bpm.feature.Configuration;
import info.novatec.micronaut.camunda.bpm.feature.initialization.ParallelInitializationWithoutProcessEngine;
import info.novatec.micronaut.camunda.bpm.feature.webapp.AdminApp;
import info.novatec.micronaut.camunda.bpm.feature.webapp.CockpitApp;
import info.novatec.micronaut.camunda.bpm.feature.webapp.EngineRestApp;
import info.novatec.micronaut.camunda.bpm.feature.webapp.TasklistApp;
import info.novatec.micronaut.camunda.bpm.feature.webapp.WebappSecurityFilter;
import info.novatec.micronaut.camunda.bpm.feature.webapp.WelcomeApp;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.camunda.bpm.admin.impl.web.bootstrap.AdminContainerBootstrap;
import org.camunda.bpm.cockpit.impl.web.bootstrap.CockpitContainerBootstrap;
import org.camunda.bpm.engine.rest.filter.CacheControlFilter;
import org.camunda.bpm.engine.rest.filter.EmptyBodyFilter;
import org.camunda.bpm.tasklist.impl.web.bootstrap.TasklistContainerBootstrap;
import org.camunda.bpm.webapp.impl.engine.ProcessEnginesFilter;
import org.camunda.bpm.webapp.impl.security.auth.AuthenticationFilter;
import org.camunda.bpm.webapp.impl.security.filter.CsrfPreventionFilter;
import org.camunda.bpm.webapp.impl.security.filter.headersec.HttpHeaderSecurityFilter;
import org.camunda.bpm.webapp.impl.security.filter.util.HttpSessionMutexListener;
import org.camunda.bpm.welcome.impl.web.bootstrap.WelcomeContainerBootstrap;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requirements(value={@Requires(beans={Server.class}), @Requires(property="camunda.webapps.enabled", value="true")})
public class JettyServerCustomizerRuntimeWebapp
implements ParallelInitializationWithoutProcessEngine {
    private static final Logger log = LoggerFactory.getLogger(JettyServerCustomizerRuntimeWebapp.class);
    protected final Server server;
    protected final String contextPath;
    protected final Map<String, String> csrfInitParams;
    protected final Map<String, String> headerSecurityInitParams;

    public JettyServerCustomizerRuntimeWebapp(Server server, Configuration configuration) {
        this.server = server;
        this.contextPath = configuration.getWebapps().getContextPath();
        this.csrfInitParams = this.getCsrfInitParams(configuration);
        this.headerSecurityInitParams = this.getHeaderSecurityInitParams(configuration);
    }

    protected Map<String, String> getCsrfInitParams(Configuration configuration) {
        HashMap<String, String> initParams = new HashMap<String, String>();
        configuration.getWebapps().getCsrf().getTargetOrigin().ifPresent(it -> initParams.put("targetOrigin", (String)it));
        configuration.getWebapps().getCsrf().getDenyStatus().ifPresent(it -> initParams.put("denyStatus", it.toString()));
        configuration.getWebapps().getCsrf().getRandomClass().ifPresent(it -> initParams.put("randomClass", (String)it));
        configuration.getWebapps().getCsrf().getEntryPoints().ifPresent(it -> initParams.put("entryPoints", String.join((CharSequence)",", it)));
        if (configuration.getWebapps().getCsrf().getEnableSecureCookie()) {
            initParams.put("enableSecureCookie", "true");
        }
        if (configuration.getWebapps().getCsrf().getEnableSameSiteCookie()) {
            configuration.getWebapps().getCsrf().getSameSiteCookieOption().ifPresent(it -> initParams.put("sameSiteCookieOption", (String)it));
            configuration.getWebapps().getCsrf().getSameSiteCookieValue().ifPresent(it -> initParams.put("sameSiteCookieValue", (String)it));
        } else {
            initParams.put("enableSameSiteCookie", "false");
        }
        configuration.getWebapps().getCsrf().getCookieName().ifPresent(it -> initParams.put("cookieName", (String)it));
        return initParams;
    }

    protected Map<String, String> getHeaderSecurityInitParams(Configuration configuration) {
        HashMap<String, String> initParams = new HashMap<String, String>();
        if (configuration.getWebapps().getHeaderSecurity().isXssProtectionDisabled()) {
            initParams.put("xssProtectionDisabled", "true");
        } else {
            configuration.getWebapps().getHeaderSecurity().getXssProtectionOption().ifPresent(it -> initParams.put("xssProtectionOption", (String)it));
            configuration.getWebapps().getHeaderSecurity().getXssProtectionValue().ifPresent(it -> initParams.put("xssProtectionValue", (String)it));
        }
        if (configuration.getWebapps().getHeaderSecurity().isContentSecurityPolicyDisabled()) {
            initParams.put("contentSecurityPolicyDisabled", "true");
        } else {
            configuration.getWebapps().getHeaderSecurity().getContentSecurityPolicyValue().ifPresent(it -> initParams.put("contentSecurityPolicyValue", (String)it));
        }
        if (configuration.getWebapps().getHeaderSecurity().isContentTypeOptionsDisabled()) {
            initParams.put("contentTypeOptionsDisabled", "true");
        } else {
            configuration.getWebapps().getHeaderSecurity().getContentTypeOptionsValue().ifPresent(it -> initParams.put("contentTypeOptionsValue", (String)it));
        }
        if (!configuration.getWebapps().getHeaderSecurity().isHstsDisabled()) {
            initParams.put("hstsDisabled", "false");
            configuration.getWebapps().getHeaderSecurity().getHstsMaxAge().ifPresent(it -> initParams.put("hstsMaxAge", it.toString()));
            if (!configuration.getWebapps().getHeaderSecurity().isHstsIncludeSubdomainsDisabled()) {
                initParams.put("hstsIncludeSubdomainsDisabled", "false");
            }
            configuration.getWebapps().getHeaderSecurity().getHstsValue().ifPresent(it -> initParams.put("hstsValue", (String)it));
        }
        return initParams;
    }

    @Override
    public void execute() throws Exception {
        ServletContextHandler webappsContextHandler = new ServletContextHandler();
        DefaultServlet defaultServlet = new DefaultServlet();
        ServletHolder webappsHolder = new ServletHolder("webapps", (Servlet)defaultServlet);
        webappsContextHandler.addServlet(webappsHolder, "/*");
        webappsContextHandler.setContextPath(this.contextPath);
        Resource webappsResource = Resource.newClassPathResource((String)"/META-INF/resources/webjars/camunda");
        Resource pluginsResource = Resource.newClassPathResource((String)"/META-INF/resources");
        ResourceCollection resources = new ResourceCollection(new Resource[]{webappsResource, pluginsResource});
        webappsContextHandler.setBaseResource((Resource)resources);
        webappsContextHandler.addEventListener((EventListener)new CockpitContainerBootstrap());
        webappsContextHandler.addEventListener((EventListener)new AdminContainerBootstrap());
        webappsContextHandler.addEventListener((EventListener)new TasklistContainerBootstrap());
        webappsContextHandler.addEventListener((EventListener)new WelcomeContainerBootstrap());
        webappsContextHandler.addEventListener((EventListener)new HttpSessionMutexListener());
        webappsContextHandler.addEventListener((EventListener)((Object)new ServletContextInitializedListener(this.csrfInitParams, this.headerSecurityInitParams)));
        webappsContextHandler.setSessionHandler(new SessionHandler());
        webappsContextHandler.setServer(this.server);
        webappsContextHandler.start();
        ((HandlerCollection)this.server.getHandler()).addHandler((Handler)webappsContextHandler);
        log.info("Webapps initialized on {}", (Object)this.contextPath);
    }

    static class ServletContextInitializedListener
    implements ServletContextListener {
        private static final Logger log = LoggerFactory.getLogger(ServletContextInitializedListener.class);
        protected static final EnumSet<DispatcherType> DISPATCHER_TYPES = EnumSet.of(DispatcherType.REQUEST);
        protected static ServletContext servletContext;
        protected final Map<String, String> csrfInitParams;
        protected final Map<String, String> headerSecurityInitParams;

        public ServletContextInitializedListener(Map<String, String> csrfInitParams, Map<String, String> headerSecurityInitParams) {
            this.csrfInitParams = csrfInitParams;
            this.headerSecurityInitParams = headerSecurityInitParams;
        }

        public void contextInitialized(ServletContextEvent sce) {
            servletContext = sce.getServletContext();
            servletContext.addServlet("CockpitApp", (Servlet)new ServletContainer((ResourceConfig)new CockpitApp())).addMapping(new String[]{"/api/cockpit/*"});
            servletContext.addServlet("AdminApp", (Servlet)new ServletContainer((ResourceConfig)new AdminApp())).addMapping(new String[]{"/api/admin/*"});
            servletContext.addServlet("TasklistApp", (Servlet)new ServletContainer((ResourceConfig)new TasklistApp())).addMapping(new String[]{"/api/tasklist/*"});
            servletContext.addServlet("EngineRestApp", (Servlet)new ServletContainer((ResourceConfig)new EngineRestApp())).addMapping(new String[]{"/api/engine/*"});
            servletContext.addServlet("WelcomeApp", (Servlet)new ServletContainer((ResourceConfig)new WelcomeApp())).addMapping(new String[]{"/api/welcome/*"});
            this.registerFilter("ProcessEnginesFilter", ProcessEnginesFilter.class, "/api/*", "/app/*");
            this.registerFilter("AuthenticationFilter", AuthenticationFilter.class, "/api/*", "/app/*");
            this.registerFilter("SecurityFilter", WebappSecurityFilter.class, Collections.singletonMap("configFile", "/securityFilterRules.json"), "/api/*", "/app/*");
            this.registerFilter("CsrfPreventionFilter", CsrfPreventionFilter.class, this.csrfInitParams, "/api/*", "/app/*");
            this.registerFilter("HttpHeaderSecurityFilter", HttpHeaderSecurityFilter.class, this.headerSecurityInitParams, "/api/*", "/app/*");
            this.registerFilter("EmptyBodyFilter", EmptyBodyFilter.class, "/api/*", "/app/*");
            this.registerFilter("CacheControlFilter", CacheControlFilter.class, "/api/*", "/app/*");
        }

        public void contextDestroyed(ServletContextEvent sce) {
        }

        protected void registerFilter(String filterName, Class<? extends Filter> filterClass, String ... urlPatterns) {
            this.registerFilter(filterName, filterClass, (Map<String, String>)null, urlPatterns);
        }

        protected void registerFilter(String filterName, Class<? extends Filter> filterClass, Map<String, String> initParams, String ... urlPatterns) {
            FilterRegistration filterRegistration = servletContext.getFilterRegistration(filterName);
            if (filterRegistration == null) {
                filterRegistration = servletContext.addFilter(filterName, filterClass);
                filterRegistration.addMappingForUrlPatterns(DISPATCHER_TYPES, true, urlPatterns);
                if (initParams != null) {
                    filterRegistration.setInitParameters(initParams);
                }
                log.debug("Filter {} for URL {} registered", (Object)filterName, (Object)urlPatterns);
            }
        }
    }
}

