/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.micronaut.zeebe.client.feature;

import info.novatec.micronaut.zeebe.client.feature.Configuration;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.ZeebeClientBuilder;
import io.camunda.zeebe.client.ZeebeClientCloudBuilderStep1;
import io.micronaut.context.annotation.Factory;
import jakarta.inject.Singleton;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Factory
public class ZeebeClientFactory {
    private static final Logger log = LoggerFactory.getLogger(ZeebeClientFactory.class);

    @Singleton
    public ZeebeClient buildClient(Configuration configuration) {
        ZeebeClient zeebeClient = this.createZeebeClientBuilder(configuration).build();
        log.info("ZeebeClient is configured to connect to gateway: {}", (Object)zeebeClient.getConfiguration().getGatewayAddress());
        return zeebeClient;
    }

    protected ZeebeClientBuilder createZeebeClientBuilder(Configuration configuration) {
        ZeebeClientBuilder zeebeClientBuilder = this.isCloudConfigurationPresent(configuration) ? this.createCloudClient(configuration) : this.createDefaultClient(configuration);
        configuration.getDefaultRequestTimeout().ifPresent(timeout -> zeebeClientBuilder.defaultRequestTimeout(Duration.parse(timeout)));
        configuration.getDefaultJobPollInterval().ifPresent(duration -> zeebeClientBuilder.defaultJobPollInterval(Duration.ofMillis(duration)));
        configuration.getDefaultJobTimeout().ifPresent(timeout -> zeebeClientBuilder.defaultJobTimeout(Duration.parse(timeout)));
        configuration.getDefaultMessageTimeToLive().ifPresent(ttl -> zeebeClientBuilder.defaultMessageTimeToLive(Duration.parse(ttl)));
        configuration.getDefaultJobWorkerName().ifPresent(arg_0 -> ((ZeebeClientBuilder)zeebeClientBuilder).defaultJobWorkerName(arg_0));
        configuration.getGatewayAddress().ifPresent(arg_0 -> ((ZeebeClientBuilder)zeebeClientBuilder).gatewayAddress(arg_0));
        configuration.getNumJobWorkerExecutionThreads().ifPresent(arg_0 -> ((ZeebeClientBuilder)zeebeClientBuilder).numJobWorkerExecutionThreads(arg_0));
        configuration.getKeepAlive().ifPresent(keepAlive -> zeebeClientBuilder.keepAlive(Duration.parse(keepAlive)));
        configuration.getCaCertificatePath().ifPresent(arg_0 -> ((ZeebeClientBuilder)zeebeClientBuilder).caCertificatePath(arg_0));
        return zeebeClientBuilder;
    }

    protected ZeebeClientBuilder createCloudClient(Configuration configuration) {
        ZeebeClientCloudBuilderStep1.ZeebeClientCloudBuilderStep2.ZeebeClientCloudBuilderStep3.ZeebeClientCloudBuilderStep4 builder = ZeebeClient.newCloudClientBuilder().withClusterId(configuration.getClusterId().get()).withClientId(configuration.getClientId().get()).withClientSecret(configuration.getClientSecret().get());
        configuration.getRegion().ifPresent(arg_0 -> ((ZeebeClientCloudBuilderStep1.ZeebeClientCloudBuilderStep2.ZeebeClientCloudBuilderStep3.ZeebeClientCloudBuilderStep4)builder).withRegion(arg_0));
        return builder;
    }

    protected ZeebeClientBuilder createDefaultClient(Configuration configuration) {
        ZeebeClientBuilder zeebeClientBuilder = ZeebeClient.newClientBuilder();
        if (configuration.getUsePlainTextConnection().orElse(true).booleanValue()) {
            zeebeClientBuilder.usePlaintext();
        }
        return zeebeClientBuilder;
    }

    protected boolean isCloudConfigurationPresent(Configuration configuration) {
        return configuration.getClusterId().isPresent() && configuration.getClientId().isPresent() && configuration.getClientSecret().isPresent();
    }
}

