/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.micronaut.zeebe.client.feature;

import info.novatec.micronaut.zeebe.client.feature.ZeebeWorker;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.client.api.worker.JobClient;
import io.camunda.zeebe.client.api.worker.JobWorker;
import io.camunda.zeebe.client.api.worker.JobWorkerBuilderStep1;
import io.micronaut.context.BeanContext;
import io.micronaut.context.processor.ExecutableMethodProcessor;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.type.Argument;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.ExecutableMethod;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Singleton;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ZeebeWorkerProcessor
implements ExecutableMethodProcessor<ZeebeWorker>,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ZeebeWorkerProcessor.class);
    protected final BeanContext beanContext;
    protected final ZeebeClient zeebeClient;
    protected Collection<JobWorker> jobWorkers = Collections.synchronizedCollection(new ArrayList());

    public ZeebeWorkerProcessor(BeanContext beanContext, ZeebeClient zeebeClient) {
        this.beanContext = beanContext;
        this.zeebeClient = zeebeClient;
    }

    public void process(BeanDefinition<?> beanDefinition, ExecutableMethod<?, ?> method) {
        this.registerJobHandler(method);
    }

    @Override
    @PreDestroy
    public void close() {
        log.info("Closing {} job workers", (Object)this.jobWorkers.size());
        this.jobWorkers.forEach(JobWorker::close);
    }

    protected void registerJobHandler(ExecutableMethod<?, ?> method) {
        AnnotationValue annotation = method.getAnnotation(ZeebeWorker.class);
        if (this.methodSignatureMatchesJobHandler(method.getArguments())) {
            Class declaringType = method.getDeclaringType();
            Object bean = this.beanContext.getBean(declaringType);
            if (annotation != null) {
                annotation.stringValue("type").ifPresent(type -> {
                    JobWorkerBuilderStep1.JobWorkerBuilderStep3 jobWorkerBuilderStep3 = this.zeebeClient.newWorker().jobType(type).handler((client, job) -> method.invoke(bean, new Object[]{client, job}));
                    annotation.stringValue("timeout").ifPresent(timeout -> jobWorkerBuilderStep3.timeout(Duration.parse(timeout)));
                    annotation.intValue("maxJobsActive").ifPresent(arg_0 -> ((JobWorkerBuilderStep1.JobWorkerBuilderStep3)jobWorkerBuilderStep3).maxJobsActive(arg_0));
                    annotation.stringValue("requestTimeout").ifPresent(requestTimeout -> jobWorkerBuilderStep3.requestTimeout(Duration.parse(requestTimeout)));
                    annotation.stringValue("pollInterval").ifPresent(pollInterval -> jobWorkerBuilderStep3.pollInterval(Duration.parse(pollInterval)));
                    JobWorker jobWorker = jobWorkerBuilderStep3.open();
                    this.jobWorkers.add(jobWorker);
                    log.info("Zeebe client ({}#{}) subscribed to type '{}'", new Object[]{bean.getClass().getName(), method.getName(), type});
                });
            }
        }
    }

    protected boolean methodSignatureMatchesJobHandler(Argument<?>[] arguments) {
        return arguments.length == 2 && arguments[0].isAssignableFrom(JobClient.class) && arguments[1].isAssignableFrom(ActivatedJob.class);
    }
}

