/*
 * Decompiled with CFR 0.152.
 */
package org.testit.testutils.logsuppressor.junit4;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.spi.LifeCycle;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.LoggerFactory;
import org.testit.testutils.logsuppressor.internal.logback.RecordingAppender;

public class LogbackSuppressorRule
implements TestRule {
    public Statement apply(Statement base, Description description) {
        return new LogbackSuppressorStatement(base);
    }

    private static class LogbackSuppressorStatement
    extends Statement {
        private final Statement next;
        private final Map<Logger, List<Appender<ILoggingEvent>>> originalStateMap = new HashMap<Logger, List<Appender<ILoggingEvent>>>();
        private final Map<Logger, RecordingAppender> rememberingAppenderMap = new HashMap<Logger, RecordingAppender>();

        public void evaluate() throws Throwable {
            this.analyzeAndStoreLoggerConfiguration();
            this.replaceAllAppenders();
            Object throwable = null;
            try {
                this.next.evaluate();
            }
            catch (AssertionError | Exception e) {
                throwable = e;
            }
            finally {
                this.restoreOriginalAppenders();
            }
            if (throwable != null) {
                this.logAllRecordedEvents();
                throw throwable;
            }
        }

        private void analyzeAndStoreLoggerConfiguration() {
            LoggerContext loggerContext = this.getLoggerContext();
            loggerContext.getLoggerList().forEach(logger -> {
                ArrayList appenders = new ArrayList();
                logger.iteratorForAppenders().forEachRemaining(appenders::add);
                if (!appenders.isEmpty()) {
                    this.originalStateMap.put((Logger)logger, appenders);
                    this.rememberingAppenderMap.put((Logger)logger, new RecordingAppender());
                }
            });
        }

        private LoggerContext getLoggerContext() {
            return (LoggerContext)LoggerFactory.getILoggerFactory();
        }

        private void replaceAllAppenders() {
            this.originalStateMap.forEach((logger, appenders) -> {
                logger.detachAndStopAllAppenders();
                logger.addAppender((Appender)this.rememberingAppenderMap.get(logger));
            });
        }

        private void restoreOriginalAppenders() {
            this.originalStateMap.forEach((logger, originalAppenders) -> {
                logger.detachAndStopAllAppenders();
                originalAppenders.stream().peek(LifeCycle::start).forEach(arg_0 -> ((Logger)logger).addAppender(arg_0));
            });
        }

        private void logAllRecordedEvents() {
            this.originalStateMap.forEach((logger, originalAppenders) -> this.rememberingAppenderMap.get(logger).getEvents().forEach(arg_0 -> ((Logger)logger).callAppenders(arg_0)));
        }

        @ConstructorProperties(value={"next"})
        public LogbackSuppressorStatement(Statement next) {
            this.next = next;
        }
    }
}

