/*
 * Decompiled with CFR 0.152.
 */
package org.testit.testutils.logsuppressor.junit5;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.spi.LifeCycle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExtensionContext;
import org.slf4j.LoggerFactory;
import org.testit.testutils.logsuppressor.internal.logback.RecordingAppender;

public class LogbackSuppressorExtension
implements BeforeTestExecutionCallback,
AfterTestExecutionCallback {
    private static final String ORIGINAL_STATE_MAP = "originalStateMap";
    private static final String REMEMBERING_APPENDER_MAP = "rememberingAppenderMap";

    public void beforeTestExecution(TestExtensionContext context) {
        this.analyzeAndStoreLoggerConfiguration(context);
        this.replaceAllAppenders(context);
    }

    private void analyzeAndStoreLoggerConfiguration(TestExtensionContext context) {
        HashMap<Logger, List<Appender<ILoggingEvent>>> originalStateMap = new HashMap<Logger, List<Appender<ILoggingEvent>>>();
        HashMap<Logger, RecordingAppender> rememberingAppenderMap = new HashMap<Logger, RecordingAppender>();
        LoggerContext loggerContext = this.getLoggerContext();
        loggerContext.getLoggerList().forEach(logger -> {
            ArrayList appenders = new ArrayList();
            logger.iteratorForAppenders().forEachRemaining(appenders::add);
            if (!appenders.isEmpty()) {
                originalStateMap.put((Logger)logger, appenders);
                rememberingAppenderMap.put((Logger)logger, new RecordingAppender());
            }
        });
        this.storeOriginalStateMap(context, originalStateMap);
        this.storeRememberingAppenderMap(context, rememberingAppenderMap);
    }

    private LoggerContext getLoggerContext() {
        return (LoggerContext)LoggerFactory.getILoggerFactory();
    }

    private void replaceAllAppenders(TestExtensionContext context) {
        Map<Logger, RecordingAppender> rememberingAppenderMap = this.getRememberingAppenderMap(context);
        this.getOriginalStateMap(context).forEach((logger, appenders) -> {
            logger.detachAndStopAllAppenders();
            logger.addAppender((Appender)rememberingAppenderMap.get(logger));
        });
    }

    public void afterTestExecution(TestExtensionContext context) {
        this.restoreOriginalAppenders(context);
        if (this.theTestFailed(context)) {
            this.logAllRecordedEvents(context);
        }
    }

    private void restoreOriginalAppenders(TestExtensionContext context) {
        Map<Logger, List<Appender<ILoggingEvent>>> originalStateMap = this.getOriginalStateMap(context);
        Map<Logger, RecordingAppender> rememberingAppenderMap = this.getRememberingAppenderMap(context);
        originalStateMap.forEach((logger, originalAppenders) -> {
            logger.detachAndStopAllAppenders();
            originalAppenders.stream().peek(LifeCycle::start).forEach(arg_0 -> ((Logger)logger).addAppender(arg_0));
        });
    }

    private boolean theTestFailed(TestExtensionContext context) {
        return context.getTestException().isPresent();
    }

    private void logAllRecordedEvents(TestExtensionContext context) {
        Map<Logger, List<Appender<ILoggingEvent>>> originalStateMap = this.getOriginalStateMap(context);
        Map<Logger, RecordingAppender> rememberingAppenderMap = this.getRememberingAppenderMap(context);
        originalStateMap.forEach((logger, originalAppenders) -> ((RecordingAppender)rememberingAppenderMap.get(logger)).getEvents().forEach(arg_0 -> ((Logger)logger).callAppenders(arg_0)));
    }

    private void storeOriginalStateMap(TestExtensionContext context, Map<Logger, List<Appender<ILoggingEvent>>> originalStateMap) {
        this.getStore(context).put((Object)ORIGINAL_STATE_MAP, originalStateMap);
    }

    private void storeRememberingAppenderMap(TestExtensionContext context, Map<Logger, RecordingAppender> rememberingAppenderMap) {
        this.getStore(context).put((Object)REMEMBERING_APPENDER_MAP, rememberingAppenderMap);
    }

    private Map<Logger, List<Appender<ILoggingEvent>>> getOriginalStateMap(TestExtensionContext context) {
        return (Map)this.getStore(context).get((Object)ORIGINAL_STATE_MAP);
    }

    private Map<Logger, RecordingAppender> getRememberingAppenderMap(TestExtensionContext context) {
        return (Map)this.getStore(context).get((Object)REMEMBERING_APPENDER_MAP);
    }

    private ExtensionContext.Store getStore(TestExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{LogbackSuppressorExtension.class}));
    }
}

