/*
 * Decompiled with CFR 0.152.
 */
package picocli.codegen.aot.graalvm;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.lang.model.util.SimpleTypeVisitor6;
import picocli.CommandLine;
import picocli.codegen.annotation.processing.AnnotatedElementHolder;
import picocli.codegen.annotation.processing.ITypeMetaData;
import picocli.codegen.aot.graalvm.OutputFileMixin;
import picocli.codegen.util.Util;

public class ReflectionConfigGenerator {
    private static final String SYSPROP_CODEGEN_EXCLUDES = "picocli.codegen.excludes";
    private static final String REFLECTED_FIELD_BINDING_CLASS = "picocli.CommandLine$Model$FieldBinding";
    private static final String REFLECTED_METHOD_BINDING_CLASS = "picocli.CommandLine$Model$MethodBinding";
    private static final String REFLECTED_PROXY_METHOD_BINDING_CLASS = "picocli.CommandLine$Model$PicocliInvocationHandler$ProxyBinding";
    private static final String REFLECTED_FIELD_BINDING_FIELD = "field";
    private static final String REFLECTED_METHOD_BINDING_METHOD = "method";
    private static final String REFLECTED_BINDING_FIELD_SCOPE = "scope";

    public static void main(String ... args) {
        App app = new App();
        int exitCode = new CommandLine((Object)app).execute(args);
        if (app.exit) {
            System.exit(exitCode);
        }
    }

    public static String generateReflectionConfig(CommandLine.Model.CommandSpec ... specs) throws Exception {
        Visitor visitor = new Visitor();
        for (CommandLine.Model.CommandSpec spec : specs) {
            visitor.visitCommandSpec(spec);
        }
        return ReflectionConfigGenerator.generateReflectionConfig(visitor).toString();
    }

    private static StringBuilder generateReflectionConfig(Visitor visited) {
        StringBuilder result = new StringBuilder(1024);
        String prefix = String.format("[%n", new Object[0]);
        String suffix = String.format("%n]%n", new Object[0]);
        for (ReflectedClass cls : visited.visited.values()) {
            result.append(prefix).append(cls);
            prefix = String.format(",%n", new Object[0]);
        }
        return result.append(suffix);
    }

    static class ReflectedField
    implements Comparable<ReflectedField> {
        private final String name;
        private final boolean isFinal;

        ReflectedField(String name, boolean isFinal) {
            this.name = name;
            this.isFinal = isFinal;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof ReflectedField && ((ReflectedField)o).name.equals(this.name);
        }

        public String toString() {
            return this.isFinal ? String.format("{ \"name\" : \"%s\", \"allowWrite\" : true }", this.name) : String.format("{ \"name\" : \"%s\" }", this.name);
        }

        @Override
        public int compareTo(ReflectedField o) {
            return this.name.compareTo(o.name);
        }
    }

    static class ReflectedMethod
    implements Comparable<ReflectedMethod> {
        private final String name;
        private final String[] paramTypes;

        ReflectedMethod(String name, String ... paramTypes) {
            this.name = name;
            this.paramTypes = (String[])paramTypes.clone();
        }

        public int hashCode() {
            return this.name.hashCode() * Arrays.hashCode(this.paramTypes);
        }

        public boolean equals(Object o) {
            return o instanceof ReflectedMethod && ((ReflectedMethod)o).name.equals(this.name) && Arrays.equals(((ReflectedMethod)o).paramTypes, this.paramTypes);
        }

        public String toString() {
            return String.format("{ \"name\" : \"%s\", \"parameterTypes\" : [%s] }", this.name, this.formatParamTypes());
        }

        private String formatParamTypes() {
            StringBuilder result = new StringBuilder();
            for (String type : this.paramTypes) {
                if (result.length() > 0) {
                    result.append(", ");
                }
                result.append('\"').append(type).append('\"');
            }
            return result.toString();
        }

        @Override
        public int compareTo(ReflectedMethod o) {
            int result = this.name.compareTo(o.name);
            if (result == 0) {
                result = Arrays.toString(this.paramTypes).compareTo(Arrays.toString(o.paramTypes));
            }
            return result;
        }
    }

    static class ReflectedClass {
        private final String name;
        private final Set<ReflectedField> fields = new TreeSet<ReflectedField>();
        private final Set<ReflectedMethod> methods = new TreeSet<ReflectedMethod>();

        ReflectedClass(Class<?> cls) {
            this(cls.getName());
        }

        ReflectedClass(String name) {
            this.name = name;
        }

        private boolean isFinal(Field f) {
            return (f.getModifiers() & 0x10) == 16;
        }

        ReflectedClass addField(Field field) {
            return this.addField(field.getName(), this.isFinal(field));
        }

        ReflectedClass addField(String fieldName, boolean isFinal) {
            this.fields.add(new ReflectedField(fieldName, isFinal));
            return this;
        }

        ReflectedClass addMethod0(String methodName, String ... paramTypes) {
            this.methods.add(new ReflectedMethod(methodName, paramTypes));
            return this;
        }

        ReflectedClass addMethod(Method method) {
            return this.addMethod(method.getName(), method.getParameterTypes());
        }

        ReflectedClass addMethod(String methodName, Class ... paramClasses) {
            String[] paramTypes = new String[paramClasses.length];
            for (int i = 0; i < paramClasses.length; ++i) {
                paramTypes[i] = paramClasses[i].getName();
            }
            return this.addMethod0(methodName, paramTypes);
        }

        public ReflectedClass addMethod(String methodName, List<String> paramTypeNames) {
            return this.addMethod0(methodName, paramTypeNames.toArray(new String[0]));
        }

        public String toString() {
            String prefix;
            String result = String.format("  {%n    \"name\" : \"%s\",%n    \"allDeclaredConstructors\" : true,%n    \"allPublicConstructors\" : true,%n    \"allDeclaredMethods\" : true,%n    \"allPublicMethods\" : true", this.name);
            if (!this.fields.isEmpty()) {
                result = result + String.format(",%n    \"fields\" : ", new Object[0]);
                prefix = String.format("[%n", new Object[0]);
                for (ReflectedField field : this.fields) {
                    result = result + String.format("%s      %s", prefix, field);
                    prefix = String.format(",%n", new Object[0]);
                }
                result = result + String.format("%n    ]", new Object[0]);
            }
            if (!this.methods.isEmpty()) {
                result = result + String.format(",%n    \"methods\" : ", new Object[0]);
                prefix = String.format("[%n", new Object[0]);
                for (ReflectedMethod method : this.methods) {
                    result = result + String.format("%s      %s", prefix, method);
                    prefix = String.format(",%n", new Object[0]);
                }
                result = result + String.format("%n    ]", new Object[0]);
            }
            result = result + String.format("%n  }", new Object[0]);
            return result;
        }
    }

    static final class Visitor {
        static Set<String> excluded = new HashSet<String>(Arrays.asList(Boolean.TYPE.getName(), boolean[].class.getName(), boolean[].class.getCanonicalName(), Byte.TYPE.getName(), byte[].class.getName(), byte[].class.getCanonicalName(), Character.TYPE.getName(), char[].class.getName(), char[].class.getCanonicalName(), Double.TYPE.getName(), double[].class.getName(), double[].class.getCanonicalName(), Float.TYPE.getName(), float[].class.getName(), float[].class.getCanonicalName(), Integer.TYPE.getName(), int[].class.getName(), int[].class.getCanonicalName(), Long.TYPE.getName(), long[].class.getName(), long[].class.getCanonicalName(), Short.TYPE.getName(), short[].class.getName(), short[].class.getCanonicalName(), CommandLine.Model.CommandSpec.class.getName(), Method.class.getName(), Object.class.getName(), String.class.getName(), String[].class.getName(), String[].class.getCanonicalName(), File.class.getName(), File[].class.getName(), File[].class.getCanonicalName(), List.class.getName(), Set.class.getName(), Map.class.getName(), "java.lang.reflect.Executable", "java.lang.reflect.Parameter", "org.fusesource.jansi.AnsiConsole", "java.util.ResourceBundle", "java.time.Duration", "java.time.Instant", "java.time.LocalDate", "java.time.LocalDateTime", "java.time.LocalTime", "java.time.MonthDay", "java.time.OffsetDateTime", "java.time.OffsetTime", "java.time.Period", "java.time.Year", "java.time.YearMonth", "java.time.ZonedDateTime", "java.time.ZoneId", "java.time.ZoneOffset", "java.nio.file.Path", "java.nio.file.Paths", "java.sql.Connection", "java.sql.Driver", "java.sql.DriverManager", "java.sql.Time", "java.sql.Timestamp"));
        Map<String, ReflectedClass> visited = new TreeMap<String, ReflectedClass>();

        Visitor() {
        }

        void visitCommandSpec(CommandLine.Model.CommandSpec spec) throws Exception {
            Object userObject = spec.userObject();
            if (userObject != null) {
                if (userObject instanceof Method) {
                    Method method = (Method)spec.userObject();
                    ReflectedClass reflectedClass = this.getOrCreateClass(method.getDeclaringClass());
                    reflectedClass.addMethod(method);
                } else if (userObject instanceof Element) {
                    this.visitElement((Element)userObject);
                } else if (!Proxy.isProxyClass(spec.userObject().getClass())) {
                    this.visitAnnotatedFields(spec.userObject().getClass());
                }
            }
            this.visitObjectType(spec.versionProvider());
            this.visitObjectType(spec.defaultValueProvider());
            for (CommandLine.Model.UnmatchedArgsBinding unmatchedArgsBinding : spec.unmatchedArgsBindings()) {
                this.visitGetter(unmatchedArgsBinding.getter());
                this.visitSetter(unmatchedArgsBinding.setter());
            }
            for (CommandLine.Model.IAnnotatedElement iAnnotatedElement : spec.specElements()) {
                this.visitGetter(iAnnotatedElement.getter());
                this.visitSetter(iAnnotatedElement.setter());
            }
            for (CommandLine.Model.IAnnotatedElement iAnnotatedElement : spec.parentCommandElements()) {
                this.visitGetter(iAnnotatedElement.getter());
                this.visitSetter(iAnnotatedElement.setter());
            }
            for (CommandLine.Model.OptionSpec optionSpec : spec.options()) {
                this.visitArgSpec((CommandLine.Model.ArgSpec)optionSpec);
            }
            for (CommandLine.Model.PositionalParamSpec positionalParamSpec : spec.positionalParameters()) {
                this.visitArgSpec((CommandLine.Model.ArgSpec)positionalParamSpec);
            }
            for (CommandLine.Model.ArgGroupSpec argGroupSpec : spec.argGroups()) {
                this.visitGroupSpec(argGroupSpec);
            }
            for (Map.Entry entry : spec.mixins().entrySet()) {
                CommandLine.Model.CommandSpec mixin = (CommandLine.Model.CommandSpec)entry.getValue();
                this.visitCommandSpec(mixin);
                String name = (String)entry.getKey();
                CommandLine.Model.IAnnotatedElement annotatedElement = (CommandLine.Model.IAnnotatedElement)spec.mixinAnnotatedElements().get(name);
                if (annotatedElement == null) continue;
                this.visitGetter(annotatedElement.getter());
            }
            for (CommandLine commandLine : spec.subcommands().values()) {
                this.visitCommandSpec(commandLine.getCommandSpec());
            }
        }

        private void visitElement(Element element) {
            element.accept(new SimpleElementVisitor6<Void, Void>(){

                @Override
                public Void visitVariable(VariableElement e, Void aVoid) {
                    if (!(e.asType().getKind().isPrimitive() || e.getKind() == ElementKind.INTERFACE && e.asType().toString().startsWith("java"))) {
                        Visitor.this.getOrCreateClassByName(Visitor.this.elementTypeName(e.asType()));
                    }
                    if (e.getKind() == ElementKind.FIELD) {
                        TypeElement type = (TypeElement)e.getEnclosingElement();
                        ReflectedClass cls = Visitor.this.getOrCreateClassByName(Visitor.this.elementTypeName(type.asType()));
                        cls.addField(e.getSimpleName().toString(), e.getModifiers().contains((Object)Modifier.FINAL));
                    }
                    return null;
                }

                @Override
                public Void visitType(TypeElement e, Void aVoid) {
                    if (!(e.asType().getKind().isPrimitive() || e.getKind() == ElementKind.INTERFACE && e.getQualifiedName().toString().startsWith("java"))) {
                        Visitor.this.getOrCreateClassByName(Visitor.this.elementTypeName(e.asType()));
                    }
                    return null;
                }

                @Override
                public Void visitExecutable(ExecutableElement method, Void aVoid) {
                    TypeElement type = (TypeElement)method.getEnclosingElement();
                    ReflectedClass cls = Visitor.this.getOrCreateClassByName(Visitor.this.elementTypeName(type.asType()));
                    List<? extends VariableElement> parameters = method.getParameters();
                    ArrayList<String> paramTypeNames = new ArrayList<String>();
                    for (VariableElement variableElement : parameters) {
                        variableElement.asType().accept(new SimpleTypeVisitor6<Void, List<String>>(){

                            @Override
                            public Void visitPrimitive(PrimitiveType t, List<String> collect) {
                                collect.add(t.toString());
                                return null;
                            }

                            @Override
                            public Void visitArray(ArrayType t, List<String> collect) {
                                collect.add(t.toString());
                                return null;
                            }

                            @Override
                            public Void visitDeclared(DeclaredType t, List<String> collect) {
                                collect.add(Visitor.this.elementTypeName(t));
                                return null;
                            }
                        }, paramTypeNames);
                    }
                    cls.addMethod(method.getSimpleName().toString(), paramTypeNames);
                    return null;
                }
            }, null);
        }

        private String elementTypeName(TypeMirror typeMirror) {
            String result = typeMirror.accept(new SimpleTypeVisitor6<String, Void>(){

                @Override
                public String visitDeclared(DeclaredType declaredType, Void aVoid) {
                    TypeElement typeElement = (TypeElement)declaredType.asElement();
                    if (typeElement.getNestingKind().isNested()) {
                        return Visitor.this.elementTypeName(typeElement.getEnclosingElement().asType()) + "$" + typeElement.getSimpleName();
                    }
                    String raw = typeElement.getQualifiedName().toString();
                    return raw;
                }

                @Override
                public String visitArray(ArrayType arrayType, Void aVoid) {
                    return Visitor.this.elementTypeName(arrayType.getComponentType()) + "[]";
                }
            }, null);
            if (result == null) {
                return typeMirror.toString();
            }
            return result;
        }

        private void visitAnnotatedFields(Class<?> cls) {
            Field[] declaredFields;
            if (cls == null) {
                return;
            }
            ReflectedClass reflectedClass = this.getOrCreateClass(cls);
            for (Field f : declaredFields = cls.getDeclaredFields()) {
                if (f.isAnnotationPresent(CommandLine.Spec.class)) {
                    reflectedClass.addField(f);
                }
                if (f.isAnnotationPresent(CommandLine.ParentCommand.class)) {
                    reflectedClass.addField(f);
                }
                if (f.isAnnotationPresent(CommandLine.Mixin.class)) {
                    reflectedClass.addField(f);
                }
                if (!f.isAnnotationPresent(CommandLine.Unmatched.class)) continue;
                reflectedClass.addField(f);
            }
            this.visitAnnotatedFields(cls.getSuperclass());
        }

        private void visitArgSpec(CommandLine.Model.ArgSpec argSpec) throws Exception {
            this.visitGetter(argSpec.getter());
            this.visitSetter(argSpec.setter());
            this.visitTypeInfo(argSpec.typeInfo());
            this.visitObjectType(argSpec.completionCandidates());
            this.visitObjectType(argSpec.parameterConsumer());
            this.visitObjectTypes(argSpec.converters());
        }

        private void visitGroupSpec(CommandLine.Model.ArgGroupSpec group) throws Exception {
            Object scopeValue;
            CommandLine.Model.IScope scope = group.scope();
            if (scope != null && (scopeValue = scope.get()) != null) {
                this.getOrCreateClass(scopeValue.getClass());
            }
            this.visitGetter(group.getter());
            this.visitSetter(group.setter());
            for (CommandLine.Model.ArgSpec argSpec : group.args()) {
                this.visitArgSpec(argSpec);
            }
            for (CommandLine.Model.ArgGroupSpec subGroup : group.subgroups()) {
                this.visitGroupSpec(subGroup);
            }
        }

        private void visitTypeInfo(CommandLine.Model.ITypeInfo typeInfo) {
            this.getOrCreateClassByName(typeInfo.getClassName());
            for (CommandLine.Model.ITypeInfo aux : typeInfo.getAuxiliaryTypeInfos()) {
                this.getOrCreateClassByName(aux.getClassName());
            }
        }

        private void visitType(Class<?> type) {
            if (type != null) {
                this.getOrCreateClass(type);
            }
        }

        private void visitObjectType(Object object) {
            if (object == null) {
                return;
            }
            if (object instanceof ITypeMetaData) {
                this.visitElement(((ITypeMetaData)object).getTypeElement());
            } else {
                this.visitType(object.getClass());
            }
        }

        private void visitObjectTypes(Object[] array) {
            if (array != null) {
                for (Object element : array) {
                    this.visitObjectType(element);
                }
            }
        }

        private void visitGetter(CommandLine.Model.IGetter getter) throws Exception {
            if (getter == null) {
                return;
            }
            if (getter instanceof AnnotatedElementHolder) {
                AnnotatedElementHolder metaData = (AnnotatedElementHolder)getter;
                this.visitElement(metaData.getElement());
            } else if (ReflectionConfigGenerator.REFLECTED_FIELD_BINDING_CLASS.equals(getter.getClass().getName())) {
                this.visitFieldBinding(getter);
            } else if (ReflectionConfigGenerator.REFLECTED_METHOD_BINDING_CLASS.equals(getter.getClass().getName())) {
                this.visitMethodBinding(getter);
            } else if (ReflectionConfigGenerator.REFLECTED_PROXY_METHOD_BINDING_CLASS.equals(getter.getClass().getName())) {
                this.visitProxyMethodBinding(getter);
            }
        }

        private void visitSetter(CommandLine.Model.ISetter setter) throws Exception {
            if (setter == null) {
                return;
            }
            if (setter instanceof AnnotatedElementHolder) {
                AnnotatedElementHolder metaData = (AnnotatedElementHolder)setter;
                this.visitElement(metaData.getElement());
            } else if (ReflectionConfigGenerator.REFLECTED_FIELD_BINDING_CLASS.equals(setter.getClass().getName())) {
                this.visitFieldBinding(setter);
            } else if (ReflectionConfigGenerator.REFLECTED_METHOD_BINDING_CLASS.equals(setter.getClass().getName())) {
                this.visitMethodBinding(setter);
            }
        }

        private void visitFieldBinding(Object fieldBinding) throws Exception {
            Field field = (Field)Visitor.accessibleField(fieldBinding.getClass(), ReflectionConfigGenerator.REFLECTED_FIELD_BINDING_FIELD).get(fieldBinding);
            this.getOrCreateClass(field.getDeclaringClass()).addField(field);
            CommandLine.Model.IScope scope = (CommandLine.Model.IScope)Visitor.accessibleField(fieldBinding.getClass(), ReflectionConfigGenerator.REFLECTED_BINDING_FIELD_SCOPE).get(fieldBinding);
            Object scopeValue = scope.get();
            if (scopeValue != null) {
                this.getOrCreateClass(scopeValue.getClass());
            }
        }

        private void visitMethodBinding(Object methodBinding) throws Exception {
            Method method = (Method)Visitor.accessibleField(methodBinding.getClass(), ReflectionConfigGenerator.REFLECTED_METHOD_BINDING_METHOD).get(methodBinding);
            ReflectedClass cls = this.getOrCreateClass(method.getDeclaringClass());
            cls.addMethod(method);
            CommandLine.Model.IScope scope = (CommandLine.Model.IScope)Visitor.accessibleField(methodBinding.getClass(), ReflectionConfigGenerator.REFLECTED_BINDING_FIELD_SCOPE).get(methodBinding);
            Object scopeValue = scope.get();
            if (scopeValue != null) {
                ReflectedClass scopeClass = this.getOrCreateClass(scopeValue.getClass());
                if (!scope.getClass().equals(method.getDeclaringClass())) {
                    scopeClass.addMethod(method);
                }
            }
        }

        private void visitProxyMethodBinding(Object methodBinding) throws Exception {
            Method method = (Method)Visitor.accessibleField(methodBinding.getClass(), ReflectionConfigGenerator.REFLECTED_METHOD_BINDING_METHOD).get(methodBinding);
            ReflectedClass cls = this.getOrCreateClass(method.getDeclaringClass());
            cls.addMethod(method);
        }

        private static Field accessibleField(Class<?> cls, String fieldName) throws NoSuchFieldException {
            Field field = cls.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }

        ReflectedClass getOrCreateClass(Class<?> cls) {
            if (cls.isPrimitive() || cls.isInterface() && cls.getName().startsWith("java")) {
                return new ReflectedClass(cls);
            }
            return this.getOrCreateClassByName(cls);
        }

        private ReflectedClass getOrCreateClassByName(Class<?> cls) {
            return this.getOrCreateClassByName(cls.getName());
        }

        private ReflectedClass getOrCreateClassByName(String name) {
            ReflectedClass result = this.visited.get(name);
            if (result == null) {
                result = new ReflectedClass(name);
                if (!Visitor.excluded(name)) {
                    this.visited.put(name, result);
                }
            }
            return result;
        }

        static boolean excluded(String fqcn) {
            String[] excludes;
            if (excluded.contains(fqcn)) {
                return true;
            }
            for (String regex : excludes = System.getProperty(ReflectionConfigGenerator.SYSPROP_CODEGEN_EXCLUDES, "").split(",")) {
                if (!fqcn.matches(regex)) continue;
                System.err.printf("Class %s is excluded: (%s=%s)%n", fqcn, ReflectionConfigGenerator.SYSPROP_CODEGEN_EXCLUDES, System.getProperty(ReflectionConfigGenerator.SYSPROP_CODEGEN_EXCLUDES));
                return true;
            }
            return false;
        }
    }

    @CommandLine.Command(name="gen-reflect-config", showAtFileInUsageHelp=true, description={"Generates a JSON file with the program elements that will be accessed reflectively for the specified `@Command` classes.", "The generated JSON file can be passed to the `-H:ReflectionConfigurationFiles=/path/to/reflect-config.json` option of the `native-image` GraalVM utility.", "See https://github.com/oracle/graal/blob/master/substratevm/REFLECTION.md"}, exitCodeListHeading="%nExit Codes (if enabled with `--exit`)%n", exitCodeList={"0:Successful program execution.", "1:A runtime exception occurred while generating man pages.", "2:Usage error: user input for the command was incorrect, e.g., the wrong number of arguments, a bad flag, a bad syntax in a parameter, etc."}, footerHeading="%nExample%n", footer={"  java -cp \"myapp.jar;picocli-4.3.2.jar;picocli-codegen-4.3.2.jar\" picocli.codegen.aot.graalvm.ReflectionConfigGenerator my.pkg.MyClass"}, mixinStandardHelpOptions=true, sortOptions=false, version={"picocli-codegen ${COMMAND-NAME} 4.3.2"})
    private static class App
    implements Callable<Integer> {
        @CommandLine.Parameters(arity="1..*", description={"One or more classes to generate a GraalVM ReflectionConfiguration for."})
        Class<?>[] classes = new Class[0];
        @CommandLine.Option(names={"-c", "--factory"}, description={"Optionally specify the fully qualified class name of the custom factory to use to instantiate the command class. When omitted, the default picocli factory is used."})
        String factoryClass;
        @CommandLine.Mixin
        OutputFileMixin outputFile = new OutputFileMixin();
        @CommandLine.Option(names={"--exit"}, negatable=true, description={"Specify `--exit` if you want the application to call `System.exit` when finished. By default, `System.exit` is not called."})
        boolean exit;

        private App() {
        }

        @Override
        public Integer call() throws Exception {
            List<CommandLine.Model.CommandSpec> specs = Util.getCommandSpecs(this.factoryClass, this.classes);
            String result = ReflectionConfigGenerator.generateReflectionConfig(specs.toArray(new CommandLine.Model.CommandSpec[0]));
            this.outputFile.write(result);
            return 0;
        }
    }
}

