/*
 * Decompiled with CFR 0.152.
 */
package picocli.groovy;

import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.PackageNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import picocli.CommandLine;
import picocli.groovy.PicocliBaseScript;
import picocli.groovy.PicocliBaseScript2;
import picocli.groovy.PicocliScript;
import picocli.groovy.PicocliScript2;

@GroovyASTTransformation(phase=CompilePhase.SEMANTIC_ANALYSIS)
public class PicocliScriptASTTransformation
extends AbstractASTTransformation {
    private static final Class<PicocliScript> MY_CLASS1 = PicocliScript.class;
    private static final Class<PicocliScript2> MY_CLASS2 = PicocliScript2.class;
    private static final Class<CommandLine.Command> COMMAND_CLASS = CommandLine.Command.class;
    private static final Class<PicocliBaseScript> BASE_SCRIPT1_CLASS = PicocliBaseScript.class;
    private static final Class<PicocliBaseScript2> BASE_SCRIPT2_CLASS = PicocliBaseScript2.class;
    private static final ClassNode MY_TYPE1 = ClassHelper.make(MY_CLASS1);
    private static final ClassNode MY_TYPE2 = ClassHelper.make(MY_CLASS2);
    private static final ClassNode COMMAND_TYPE = ClassHelper.make(COMMAND_CLASS);
    private static final ClassNode BASE_SCRIPT1_TYPE = ClassHelper.make(BASE_SCRIPT1_CLASS);
    private static final ClassNode BASE_SCRIPT2_TYPE = ClassHelper.make(BASE_SCRIPT2_CLASS);
    private static final String MY_TYPE_NAME1 = "@" + MY_TYPE1.getNameWithoutPackage();
    private static final String MY_TYPE_NAME2 = "@" + MY_TYPE2.getNameWithoutPackage();
    private static final Parameter[] CONTEXT_CTOR_PARAMETERS = new Parameter[]{new Parameter(ClassHelper.BINDING_TYPE, "context")};

    public void visit(ASTNode[] nodes, SourceUnit source) {
        this.init(nodes, source);
        AnnotatedNode parent = (AnnotatedNode)nodes[1];
        AnnotationNode node = (AnnotationNode)nodes[0];
        if (!MY_TYPE1.equals((Object)node.getClassNode()) && !MY_TYPE2.equals((Object)node.getClassNode())) {
            return;
        }
        if (parent instanceof DeclarationExpression) {
            this.changeBaseScriptTypeFromDeclaration(source, (DeclarationExpression)parent, node);
        } else if (parent instanceof ImportNode || parent instanceof PackageNode) {
            this.changeBaseScriptTypeFromPackageOrImport(source, parent, node);
        } else if (parent instanceof ClassNode) {
            this.changeBaseScriptTypeFromClass(source, (ClassNode)parent, node);
        }
    }

    private static ClassNode scriptType(AnnotationNode node) {
        if (MY_TYPE1.equals((Object)node.getClassNode())) {
            return BASE_SCRIPT1_TYPE;
        }
        if (MY_TYPE2.equals((Object)node.getClassNode())) {
            return BASE_SCRIPT2_TYPE;
        }
        throw new IllegalStateException("Expected annotation @PicocliScript or @PicocliScript2, but was " + node.getClassNode());
    }

    private static String annotationTypeName(AnnotationNode node) {
        if (MY_TYPE1.equals((Object)node.getClassNode())) {
            return MY_TYPE_NAME1;
        }
        if (MY_TYPE2.equals((Object)node.getClassNode())) {
            return MY_TYPE_NAME2;
        }
        throw new IllegalStateException("Expected annotation @PicocliScript or @PicocliScript2, but was " + node.getClassNode());
    }

    private void changeBaseScriptTypeFromPackageOrImport(SourceUnit source, AnnotatedNode parent, AnnotationNode node) {
        ClassNode scriptType;
        Expression value = node.getMember("value");
        if (value == null) {
            scriptType = PicocliScriptASTTransformation.scriptType(node);
        } else {
            if (!(value instanceof ClassExpression)) {
                this.addError("Annotation " + PicocliScriptASTTransformation.annotationTypeName(node) + " member 'value' should be a class literal.", (ASTNode)value);
                return;
            }
            scriptType = value.getType();
        }
        List classes = source.getAST().getClasses();
        for (ClassNode classNode : classes) {
            if (!classNode.isScriptBody()) continue;
            this.changeBaseScriptType(source, parent, classNode, scriptType, node);
        }
    }

    private void changeBaseScriptTypeFromClass(SourceUnit source, ClassNode parent, AnnotationNode node) {
        this.changeBaseScriptType(source, (AnnotatedNode)parent, parent, parent.getSuperClass(), node);
    }

    private void changeBaseScriptTypeFromDeclaration(SourceUnit source, DeclarationExpression de, AnnotationNode node) {
        if (de.isMultipleAssignmentDeclaration()) {
            this.addError("Annotation " + PicocliScriptASTTransformation.annotationTypeName(node) + " not supported with multiple assignment notation.", (ASTNode)de);
            return;
        }
        ClassNode cNode = de.getDeclaringClass();
        ClassNode baseScriptType = de.getVariableExpression().getType().getPlainNodeReference();
        if (baseScriptType.isScript()) {
            if (!(de.getRightExpression() instanceof EmptyExpression)) {
                this.addError("Annotation " + PicocliScriptASTTransformation.annotationTypeName(node) + " not supported with variable assignment.", (ASTNode)de);
                return;
            }
            de.setRightExpression((Expression)new VariableExpression("this"));
        } else {
            baseScriptType = PicocliScriptASTTransformation.scriptType(node);
        }
        Expression value = node.getMember("value");
        if (value != null) {
            this.addError("Annotation " + PicocliScriptASTTransformation.annotationTypeName(node) + " cannot have member 'value' if used on a declaration.", (ASTNode)value);
            return;
        }
        this.changeBaseScriptType(source, (AnnotatedNode)de, cNode, baseScriptType, node);
    }

    private void changeBaseScriptType(SourceUnit source, AnnotatedNode parent, ClassNode cNode, ClassNode baseScriptType, AnnotationNode node) {
        MethodNode defaultMethod;
        if (!cNode.isScriptBody()) {
            this.addError("Annotation " + PicocliScriptASTTransformation.annotationTypeName(node) + " can only be used within a Script.", (ASTNode)parent);
            return;
        }
        if (!baseScriptType.isScript()) {
            this.addError("Declared type " + baseScriptType + " does not extend groovy.lang.Script class!", (ASTNode)parent);
            return;
        }
        List annotations = parent.getAnnotations(COMMAND_TYPE);
        if (cNode.getAnnotations(COMMAND_TYPE).isEmpty()) {
            cNode.addAnnotations(annotations);
        }
        cNode.setSuperClass(baseScriptType);
        MethodNode runScriptMethod = ClassHelper.findSAM((ClassNode)baseScriptType);
        if (this.isCustomScriptBodyMethod(runScriptMethod) && (defaultMethod = cNode.getDeclaredMethod("run", Parameter.EMPTY_ARRAY)) != null) {
            cNode.removeMethod(defaultMethod);
            MethodNode methodNode = new MethodNode(runScriptMethod.getName(), runScriptMethod.getModifiers() & 0xFFFFFBFF, runScriptMethod.getReturnType(), runScriptMethod.getParameters(), runScriptMethod.getExceptions(), defaultMethod.getCode());
            methodNode.copyNodeMetaData((ASTNode)defaultMethod);
            cNode.addMethod(methodNode);
        }
        if (cNode.getSuperClass().getDeclaredConstructor(CONTEXT_CTOR_PARAMETERS) == null) {
            ConstructorNode orphanedConstructor = cNode.getDeclaredConstructor(CONTEXT_CTOR_PARAMETERS);
            cNode.removeConstructor(orphanedConstructor);
        }
    }

    private boolean isCustomScriptBodyMethod(MethodNode node) {
        return node != null && (!node.getDeclaringClass().equals((Object)ClassHelper.SCRIPT_TYPE) || !"run".equals(node.getName()) || node.getParameters().length != 0);
    }
}

