/*
 * Decompiled with CFR 0.152.
 */
package picocli.spring;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import picocli.CommandLine;

public class PicocliSpringFactory
implements CommandLine.IFactory {
    private static final Logger logger = LoggerFactory.getLogger(PicocliSpringFactory.class);
    private final ApplicationContext applicationContext;

    public PicocliSpringFactory(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public <K> K create(Class<K> clazz) throws Exception {
        try {
            return this.getBeanOrCreate(clazz);
        }
        catch (Exception e) {
            logger.warn("Unable to get bean of class {}, using default Picocli factory", clazz);
            return (K)CommandLine.defaultFactory().create(clazz);
        }
    }

    private <K> K getBeanOrCreate(Class<K> clazz) {
        try {
            return (K)this.applicationContext.getBean(clazz);
        }
        catch (Exception e) {
            return (K)this.applicationContext.getAutowireCapableBeanFactory().createBean(clazz);
        }
    }
}

