/*
 * Decompiled with CFR 0.152.
 */
package info.plichta.maven.plugins.changelog;

import info.plichta.maven.plugins.changelog.ChangeLogWriter;
import info.plichta.maven.plugins.changelog.CommitFilter;
import info.plichta.maven.plugins.changelog.RepositoryProcessor;
import info.plichta.maven.plugins.changelog.handlers.CommitHandler;
import info.plichta.maven.plugins.changelog.handlers.JiraHandler;
import info.plichta.maven.plugins.changelog.handlers.PullRequestHandler;
import info.plichta.maven.plugins.changelog.model.ChangeLog;
import info.plichta.maven.plugins.changelog.model.TagWrapper;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="git-changelog")
public class ChangeLogMojo
extends AbstractMojo {
    private static final String DEFAULT_TEMPLATE = "changelog.mustache";
    @Parameter(property="project.basedir")
    private File repoRoot;
    @Parameter(defaultValue="${project.basedir}/CHANGELOG.md")
    private File outputFile;
    @Parameter(defaultValue="Change Log")
    private String reportTitle;
    @Parameter(defaultValue="${project.basedir}/changelog.mustache")
    private File templateFile;
    @Parameter(defaultValue=".*")
    private String includeCommits;
    @Parameter(defaultValue="^\\[maven-release-plugin\\].*")
    private String excludeCommits;
    @Parameter
    private String gitHubUrl;
    @Parameter
    private String scmUrl;
    @Parameter(property="project.version")
    private String nextRelease;
    @Parameter(defaultValue="true")
    private boolean deduplicateChildCommits;
    @Parameter
    private String jiraServer;
    @Parameter(defaultValue="HEAD")
    private String toRef;
    @Parameter(defaultValue="")
    private String pathFilter;
    @Parameter(property="project.artifactId")
    private String tagPrefix;
    @Parameter
    private LocalDateTime ignoreOlderThen;
    @Parameter(defaultValue="false")
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        List<TagWrapper> tags;
        if (this.skip) {
            return;
        }
        String template = Optional.of(this.templateFile).filter(File::canRead).map(File::toString).orElse(DEFAULT_TEMPLATE);
        ChangeLogWriter logGenerator = new ChangeLogWriter(template, this.getLog());
        CommitFilter commitFilter = new CommitFilter(this.includeCommits, this.excludeCommits, this.ignoreOlderThen);
        ArrayList<CommitHandler> commitHandlers = new ArrayList<CommitHandler>();
        if (this.gitHubUrl != null || this.scmUrl != null) {
            commitHandlers.add(new PullRequestHandler(this.gitHubUrl));
        }
        if (this.jiraServer != null) {
            commitHandlers.add(new JiraHandler(this.jiraServer));
        }
        RepositoryProcessor repositoryProcessor = new RepositoryProcessor(this.deduplicateChildCommits, this.toRef, this.nextRelease, this.constructScmUrl(), commitFilter, commitHandlers, this.pathFilter, this.tagPrefix, this.getLog());
        try {
            tags = repositoryProcessor.process(this.repoRoot);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot process repository " + this.repoRoot, (Exception)e);
        }
        logGenerator.write(this.outputFile, new ChangeLog(this.reportTitle, tags));
    }

    private String constructScmUrl() {
        if (this.gitHubUrl != null) {
            return StringUtils.stripEnd((String)this.gitHubUrl, (String)"/") + "/commit";
        }
        if (this.scmUrl != null) {
            return StringUtils.stripEnd((String)this.scmUrl, (String)"/");
        }
        return null;
    }
}

