/*
 * Decompiled with CFR 0.152.
 */
package info.plichta.maven.plugins.changelog;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import info.plichta.maven.plugins.changelog.model.ChangeLog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.maven.plugin.logging.Log;

public class ChangeLogWriter {
    private final Log log;
    private final Mustache mustache;

    public ChangeLogWriter(String template, Log log) {
        this.log = log;
        DefaultMustacheFactory mustacheFactory = new DefaultMustacheFactory();
        this.mustache = mustacheFactory.compile(template);
    }

    public void write(File target, ChangeLog changeLog) {
        this.log.info((CharSequence)("Writing changelog to file " + target));
        try (PrintWriter writer = new PrintWriter(target);){
            this.mustache.execute((Writer)writer, (Object)changeLog);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

