/*
 * Decompiled with CFR 0.152.
 */
package info.plichta.maven.plugins.changelog;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.eclipse.jgit.revwalk.RevCommit;

public class CommitFilter
implements Predicate<RevCommit> {
    private final Predicate<RevCommit> predicate;
    private static final long MILLISECONDS = 1000L;

    CommitFilter(String include, String exclude, LocalDateTime ignoreOlderThen) {
        Pattern includePattern = Pattern.compile(include, 40);
        Optional<Pattern> excludePattern = Optional.ofNullable(exclude).map(regex -> Pattern.compile(regex, 40));
        Predicate<RevCommit> includePred = revCommit -> includePattern.matcher(revCommit.getFullMessage()).matches();
        Predicate<RevCommit> excludePred = revCommit -> excludePattern.map(p -> p.matcher(revCommit.getFullMessage()).matches()).orElse(false);
        int maxTime = this.getMinimumCommitTime(ignoreOlderThen);
        Predicate<RevCommit> timePred = revCommit -> revCommit.getCommitTime() >= maxTime;
        this.predicate = includePred.and(excludePred.negate()).and(timePred);
    }

    private int getMinimumCommitTime(LocalDateTime ignoreOlderThen) {
        if (ignoreOlderThen != null) {
            return (int)(ignoreOlderThen.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli() / 1000L);
        }
        return 0;
    }

    @Override
    public boolean test(RevCommit revCommit) {
        return this.predicate.test(revCommit);
    }
}

