/*
 * Decompiled with CFR 0.152.
 */
package info.plichta.maven.plugins.changelog;

import info.plichta.maven.plugins.changelog.handlers.CommitHandler;
import info.plichta.maven.plugins.changelog.model.CommitWrapper;
import info.plichta.maven.plugins.changelog.model.TagWrapper;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.io.DisabledOutputStream;

public class RepositoryProcessor {
    private final Pattern tagPattern;
    private final Log log;
    private final boolean deduplicateChildCommits;
    private final String toRef;
    private final String nextRelease;
    private final String gitHubUrl;
    private final Predicate<RevCommit> commitFilter;
    private final List<CommitHandler> commitHandlers = new ArrayList<CommitHandler>();
    private final TreeFilter pathFilter;

    public RepositoryProcessor(boolean deduplicateChildCommits, String toRef, String nextRelease, String gitHubUrl, Predicate<RevCommit> commitFilter, List<CommitHandler> commitHandlers, String pathFilter, String tagPrefix, Log log) {
        this.deduplicateChildCommits = deduplicateChildCommits;
        this.toRef = toRef;
        this.nextRelease = nextRelease;
        this.gitHubUrl = gitHubUrl;
        this.commitFilter = commitFilter;
        this.pathFilter = !StringUtils.isBlank((CharSequence)pathFilter) && !"/".equals(pathFilter) ? PathFilter.create((String)pathFilter) : PathFilter.ALL;
        this.commitHandlers.addAll(commitHandlers);
        this.tagPattern = Pattern.compile(tagPrefix + "-([^-]+?)$");
        this.log = log;
    }

    public List<TagWrapper> process(File repoRoot) throws IOException {
        try (Repository repository = ((RepositoryBuilder)new RepositoryBuilder().findGitDir(repoRoot)).build();){
            List<TagWrapper> list = this.process(repository);
            return list;
        }
    }

    public List<TagWrapper> process(Repository repository) throws IOException {
        ArrayList<TagWrapper> tags = new ArrayList<TagWrapper>();
        this.log.info((CharSequence)("Processing git repository " + repository.getDirectory()));
        ObjectId head = repository.resolve(this.toRef);
        if (head == null) {
            return tags;
        }
        try (RevWalk walk = new RevWalk(repository);){
            walk.sort(RevSort.TOPO);
            Map<ObjectId, TagWrapper> tagMapping = this.extractTags(repository, walk);
            TagWrapper currentTag = new TagWrapper(this.nextRelease);
            tags.add(currentTag);
            RevCommit commit = walk.parseCommit((AnyObjectId)head);
            while (commit != null) {
                RevCommit[] parents;
                currentTag = tagMapping.getOrDefault(commit.getId(), currentTag);
                if (tagMapping.containsKey(commit.getId())) {
                    tags.add(currentTag);
                }
                CommitWrapper commitWrapper = this.processCommit(commit);
                if (this.commitFilter.test(commit) && this.isInPath(repository, walk, commit)) {
                    currentTag.getCommits().add(commitWrapper);
                }
                if ((parents = commit.getParents()) != null && parents.length > 0) {
                    RevCommit parent = walk.parseCommit((AnyObjectId)parents[0]);
                    try (RevWalk childWalk = new RevWalk(repository);){
                        childWalk.markStart(childWalk.parseCommit((AnyObjectId)commit));
                        childWalk.markUninteresting(childWalk.parseCommit((AnyObjectId)parent));
                        childWalk.next();
                        for (RevCommit childCommit : childWalk) {
                            CommitWrapper childWrapper = this.processCommit(childCommit);
                            if (!this.commitFilter.test(childCommit) || !this.isInPath(repository, walk, commit) || this.deduplicateChildCommits && Objects.equals(commitWrapper.getTitle(), childWrapper.getTitle())) continue;
                            commitWrapper.getChildren().add(childWrapper);
                        }
                    }
                    commit = parent;
                    continue;
                }
                commit = null;
            }
        }
        return tags;
    }

    private Map<ObjectId, TagWrapper> extractTags(Repository repository, RevWalk walk) throws IOException {
        HashMap<ObjectId, TagWrapper> tagMapping = new HashMap<ObjectId, TagWrapper>();
        for (Map.Entry entry : repository.getTags().entrySet()) {
            String name = (String)entry.getKey();
            Matcher matcher = this.tagPattern.matcher(name);
            if (!matcher.matches()) continue;
            name = matcher.group(1);
            tagMapping.put((ObjectId)walk.parseCommit((AnyObjectId)((Ref)entry.getValue()).getObjectId()), new TagWrapper(name));
        }
        return tagMapping;
    }

    private boolean isInPath(Repository repository, RevWalk walk, RevCommit commit) throws IOException {
        if (commit.getParentCount() == 0) {
            RevTree tree = commit.getTree();
            try (TreeWalk treeWalk = new TreeWalk(repository);){
                treeWalk.addTree((AnyObjectId)tree);
                treeWalk.setRecursive(true);
                treeWalk.setFilter(this.pathFilter);
                boolean bl = treeWalk.next();
                return bl;
            }
        }
        DiffFormatter df = new DiffFormatter((OutputStream)DisabledOutputStream.INSTANCE);
        df.setRepository(repository);
        df.setPathFilter(this.pathFilter);
        RevCommit parent = walk.parseCommit((AnyObjectId)commit.getParent(0).getId());
        List diffs = df.scan(parent.getTree(), commit.getTree());
        return !diffs.isEmpty();
    }

    private CommitWrapper processCommit(RevCommit commit) {
        CommitWrapper commitWrapper = new CommitWrapper(commit, this.gitHubUrl);
        for (CommitHandler listener : this.commitHandlers) {
            listener.handle(commitWrapper);
        }
        return commitWrapper;
    }
}

