/*
 * Decompiled with CFR 0.152.
 */
package info.plichta.maven.plugins.changelog.handlers;

import info.plichta.maven.plugins.changelog.handlers.CommitHandler;
import info.plichta.maven.plugins.changelog.model.CommitWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JiraHandler
implements CommitHandler {
    private static final Pattern PATTERN = Pattern.compile("([A-Z]+-[0-9]+)");
    private final String jiraServer;

    public JiraHandler(String jiraServer) {
        this.jiraServer = jiraServer;
    }

    @Override
    public void handle(CommitWrapper commit) {
        Matcher matcher = PATTERN.matcher(commit.getTitle());
        JiraIssue jira = new JiraIssue();
        int lastEnd = 0;
        while (matcher.find()) {
            if (matcher.start() > lastEnd) {
                jira.getTitle().add(new TitleToken(commit.getTitle().substring(lastEnd, matcher.start()), null));
            }
            String issue = matcher.group(1);
            lastEnd = matcher.end();
            jira.getTitle().add(new TitleToken(issue, new JiraLink(issue, this.jiraServer + "/browse/" + issue)));
        }
        jira.getTitle().add(new TitleToken(commit.getTitle().substring(lastEnd, commit.getTitle().length()), null));
        if (jira.getTitle().size() > 1) {
            commit.getExtensions().put("jira", jira);
        }
    }

    public static class JiraLink {
        private final String id;
        private final String link;

        public JiraLink(String id, String link) {
            this.id = id;
            this.link = link;
        }

        public String getId() {
            return this.id;
        }

        public String getLink() {
            return this.link;
        }
    }

    public static class TitleToken {
        private final String token;
        private final JiraLink link;

        public TitleToken(String token, JiraLink link) {
            this.token = token;
            this.link = link;
        }

        public String getToken() {
            return this.token;
        }

        public JiraLink getLink() {
            return this.link;
        }
    }

    public static class JiraIssue {
        private final List<TitleToken> title = new ArrayList<TitleToken>();

        public List<TitleToken> getTitle() {
            return this.title;
        }
    }
}

