/*
 * Decompiled with CFR 0.152.
 */
package info.plichta.maven.plugins.changelog.handlers;

import info.plichta.maven.plugins.changelog.handlers.CommitHandler;
import info.plichta.maven.plugins.changelog.model.CommitWrapper;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class PullRequestHandler
implements CommitHandler {
    private static final Pattern PATTERN = Pattern.compile("Merge pull request #(\\d+).*");
    private final String gitHubUrl;

    public PullRequestHandler(String gitHubUrl) {
        this.gitHubUrl = gitHubUrl;
    }

    @Override
    public void handle(CommitWrapper commit) {
        String shortMessage = commit.getCommit().getShortMessage();
        Matcher matcher = PATTERN.matcher(shortMessage);
        if (matcher.matches()) {
            String fullMessage = commit.getCommit().getFullMessage();
            Object[] lines = fullMessage.split("\n");
            String title = (String)ArrayUtils.get((Object[])lines, (int)2, (Object)fullMessage);
            commit.setTitle(title);
            String id = matcher.group(1);
            commit.getExtensions().put("pullRequest", new PullRequest(id, title, StringUtils.stripEnd((String)this.gitHubUrl, (String)"/") + "/pull/" + id));
        }
    }

    public static class PullRequest {
        private final String id;
        private final String title;
        private final String link;

        public PullRequest(String id, String title, String link) {
            this.id = id;
            this.title = title;
            this.link = link;
        }

        public String getId() {
            return this.id;
        }

        public String getTitle() {
            return this.title;
        }

        public String getLink() {
            return this.link;
        }
    }
}

