/*
 * Decompiled with CFR 0.152.
 */
package info.plichta.maven.plugins.changelog.model;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.revwalk.RevCommit;

public class CommitWrapper {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final long MILLISECONDS = 1000L;
    private final String scmUrl;
    private final RevCommit commit;
    private String title;
    private final Map<String, Object> extensions = new HashMap<String, Object>();
    private final List<CommitWrapper> children = new ArrayList<CommitWrapper>();

    public CommitWrapper(RevCommit commit, String scmUrl) {
        this.scmUrl = scmUrl;
        this.commit = commit;
        this.title = commit.getShortMessage();
    }

    public RevCommit getCommit() {
        return this.commit;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getShortHash() {
        return StringUtils.left((String)this.commit.getName(), (int)7);
    }

    public String getCommitLink() {
        return this.scmUrl == null ? this.commit.getName() : this.scmUrl + "/" + this.commit.getName();
    }

    public List<CommitWrapper> getChildren() {
        return this.children;
    }

    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public String getCommitTime() {
        return Instant.ofEpochMilli((long)this.commit.getCommitTime() * 1000L).atZone(ZoneId.systemDefault()).toLocalDateTime().format(DATE_FORMAT);
    }
}

